/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.teamislands;

import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="teamislands")
@Config(modid="teamislands", category="")
public class TeamIslandsConfig {
    @Config.LangKey(value="stat.generalButton")
    public static final General general = new General();
    public static final Lobby lobby = new Lobby();
    public static final Islands islands = new Islands();

    public static void sync() {
        ConfigManager.sync((String)"teamislands", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("teamislands")) {
            TeamIslandsConfig.sync();
        }
    }

    public static class Islands {
        @Config.RangeInt(min=-1, max=255)
        @Config.Comment(value={"Height at which the islands will generate.", "-1 = auto, on top of highest block in world"})
        public int height = 80;
        @Config.Comment(value={"Structure files will be loaded from config/x file.", "If not set, builtin island will be used."})
        @Config.RequiresWorldRestart
        public String[] structure_files = new String[0];
        @Config.Comment(value={"Radius of the chunks to automatically claim if FTBUtilities is installed.", "-1 = disabled", "0 = 1x1", "1 = 3x3", "4 = 9x9"})
        public int autoclaim_radius = 4;
        @Config.Comment(value={"Allow selection of the island type, if set to false, then islands will be randomized."})
        public boolean select_islands = true;
    }

    public static class Lobby {
        @Config.Comment(value={"Auto-teleports player to their island once they join a team."})
        public boolean autoteleport_to_island = true;
    }

    public static class General {
        public boolean enabled_singleplayer = false;
        public boolean enabled_multiplayer = true;
        public boolean clear_inv_when_team_left = true;
        public boolean enable_myisland_command = true;
        public String void_world_type_id = "void";

        public boolean isEnabled(MinecraftServer server) {
            return server.func_71262_S() ? this.enabled_multiplayer : this.enabled_singleplayer;
        }
    }
}

