/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.events;

import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementAboutToLoadEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementBuildEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementCompletionEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementCriterionCompletedEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementVisibilityEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.FunctionReloadEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.GrantCriterionEvent;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.RepeatableHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.CountHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.CustomCriteriaTriggers;
import com.bloodnbonesgaming.triumph.advancements.display.ExtendedDisplayInfo;
import com.bloodnbonesgaming.triumph.advancements.display.VisibilityOption;
import com.bloodnbonesgaming.triumph.config.ConfigurationManager;
import java.util.ArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CoreEventHandler {
    public static boolean initialized = false;

    @SubscribeEvent
    public void onAdvancementBuildEventPre(AdvancementBuildEvent.Pre event) {
        CountHandler.onAdvancementReload();
        RepeatableHandler.cleanUp();
        initialized = false;
        ConfigurationManager.removeModAdvancements(event.getAdvancementMap());
        ConfigurationManager.loadAdvancments(event.getAdvancementMap());
    }

    @SubscribeEvent
    public void onAdvancementBuildEventPost(AdvancementBuildEvent.Post event) {
    }

    @SubscribeEvent
    public void onFunctionReloadEventPost(FunctionReloadEvent.Post event) {
        if (Triumph.serverStarted) {
            ConfigurationManager.loadFunctions(event.getFunctionManager(), event.getFunctionManager().func_193066_d());
        }
        Triumph.proxy.scheduleAdvancementVisibilityUpdate();
    }

    @SubscribeEvent
    public void onAdvancementCriterionCompleted(AdvancementCriterionCompletedEvent event) {
        if (event.getAdvancementProgress().func_192105_a()) {
            CustomCriteriaTriggers.COMPLETED_ADVANCEMENT.trigger(event.getPlayer(), event.getAdvancement().func_192067_g().toString());
        }
    }

    @SubscribeEvent
    public void onAdvancementAboutToLoad(AdvancementAboutToLoadEvent event) {
        if (!initialized) {
            initialized = true;
            ConfigurationManager.init();
        }
        if (event.getLocation().func_110624_b().equals("minecraft") && ConfigurationManager.getMainConfig().shouldRemoveVanillaAdvancements()) {
            event.setCanceled(true);
        } else {
            String[] removeAdvancements;
            ResourceLocation location = event.getLocation();
            String[] keepAdvancements = ConfigurationManager.getMainConfig().getKeepAdvancements();
            if (keepAdvancements.length > 0) {
                boolean remove = true;
                for (String keep : keepAdvancements) {
                    if (!keep.equals(location.func_110624_b()) && !keep.equals(location.toString())) continue;
                    remove = false;
                    break;
                }
                if (remove) {
                    event.setCanceled(true);
                    return;
                }
            }
            if ((removeAdvancements = ConfigurationManager.getMainConfig().getRemoveAdvancements()).length > 0) {
                for (String remove : removeAdvancements) {
                    if (!remove.equals(location.func_110624_b()) && !remove.equals(location.toString())) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onGrantCriterion(GrantCriterionEvent event) {
        if (!CountHandler.increment(event.getPlayerAdvancements().field_192762_j.func_110124_au().toString(), event.getAdvancement().func_192067_g().toString(), event.getCriterionName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAdvancementVisibilityCheck(AdvancementVisibilityEvent event) {
        Advancement advancement = event.getAdvancement();
        PlayerAdvancements advancements = event.getAdvancements();
        boolean visible = this.isChildOrSelfVisible(advancements, advancement);
        event.setCanceled(visible ? true : this.checkParentVisibility(advancement, advancements, 0));
    }

    private boolean checkParentVisibility(Advancement startAdv, PlayerAdvancements advancements, int currentDepth) {
        DisplayInfo display;
        DisplayInfo display2 = startAdv.func_192068_c();
        if (display2 != null && display2 instanceof ExtendedDisplayInfo) {
            ExtendedDisplayInfo ext = (ExtendedDisplayInfo)display2;
            for (VisibilityOption visibilityOption : ext.getVisibilityOptions()) {
                Boolean visibility = visibilityOption.visible(advancements);
                if (visibility == null) continue;
                return visibility;
            }
        }
        if (startAdv.func_192068_c() == null) {
            return false;
        }
        if (advancements.func_192747_a(startAdv).func_192105_a()) {
            return true;
        }
        if (startAdv.func_192068_c().func_193224_j()) {
            return false;
        }
        ArrayList<Advancement> parents = new ArrayList<Advancement>();
        if (startAdv.func_192070_b() != null) {
            parents.add(startAdv.func_192070_b());
        }
        if ((display = startAdv.func_192068_c()) != null && display instanceof ExtendedDisplayInfo) {
            ExtendedDisplayInfo ext = (ExtendedDisplayInfo)display;
            for (ResourceLocation location : ext.getExtraConnections()) {
                AdvancementManager manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_191949_aK();
                Advancement advancement = manager.func_192778_a(location);
                if (advancement == null) continue;
                parents.add(advancement);
            }
        }
        for (Advancement parent : parents) {
            DisplayInfo display3;
            DisplayInfo displayInfo = parent.func_192068_c();
            if (displayInfo != null && displayInfo instanceof ExtendedDisplayInfo) {
                ExtendedDisplayInfo ext = (ExtendedDisplayInfo)displayInfo;
                for (VisibilityOption visibilityOption : ext.getVisibilityOptions()) {
                    Boolean visibility = visibilityOption.visible(advancements);
                    if (visibility == null) continue;
                    return visibility;
                }
            }
            if (parent.func_192068_c() == null) {
                return false;
            }
            if (advancements.func_192747_a(parent).func_192105_a()) {
                return true;
            }
            if (parent.func_192068_c().func_193224_j()) {
                return false;
            }
            ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
            if (parent.func_192070_b() != null) {
                arrayList.add(parent.func_192070_b());
            }
            if ((display3 = parent.func_192068_c()) != null && display3 instanceof ExtendedDisplayInfo) {
                ExtendedDisplayInfo ext = (ExtendedDisplayInfo)display3;
                for (ResourceLocation location : ext.getExtraConnections()) {
                    AdvancementManager manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_191949_aK();
                    Advancement connection = manager.func_192778_a(location);
                    if (connection == null) continue;
                    arrayList.add(connection);
                }
            }
            for (Advancement subParent : arrayList) {
                DisplayInfo displayInfo2 = subParent.func_192068_c();
                if (displayInfo2 != null && displayInfo2 instanceof ExtendedDisplayInfo) {
                    ExtendedDisplayInfo ext = (ExtendedDisplayInfo)displayInfo2;
                    for (VisibilityOption option : ext.getVisibilityOptions()) {
                        Boolean visibility = option.visible(advancements);
                        if (visibility == null) continue;
                        return visibility;
                    }
                }
                if (subParent.func_192068_c() == null) {
                    return false;
                }
                if (advancements.func_192747_a(subParent).func_192105_a()) {
                    return true;
                }
                if (!subParent.func_192068_c().func_193224_j()) continue;
                return false;
            }
        }
        return false;
    }

    private boolean isChildOrSelfVisible(PlayerAdvancements advancements, Advancement advancement) {
        if (this.checkParentVisibility(advancement, advancements, 0)) {
            return true;
        }
        for (Advancement adv : advancement.func_192069_e()) {
            if (!this.isChildOrSelfVisible(advancements, adv)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onAdvancementCompletionEvent(AdvancementCompletionEvent event) {
        AdvancementProgress progress = event.getAdvancementProgress();
        if (progress.field_192111_b.length == 0) {
            event.setCanceled(false);
            return;
        }
        for (String[] astring : progress.field_192111_b) {
            boolean flag = false;
            for (String s : astring) {
                CriterionProgress criterionprogress = progress.func_192106_c(s);
                if (s.startsWith("!")) {
                    if (criterionprogress != null && criterionprogress.func_192151_a()) continue;
                    flag = true;
                    break;
                }
                if (criterionprogress == null || !criterionprogress.func_192151_a()) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            event.setCanceled(false);
            return;
        }
        event.setCanceled(true);
    }
}

