/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.config.data.DamageSourceData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import net.minecraft.advancements.critereon.DamagePredicate;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/dataObjects/DamageData", classExplaination="These are the functions which can be called on a DamageData object.")
public class DamageData {
    private DamageSourceData damageSourceData;
    private EntityData entityData;
    private Boolean blocked;
    private MinMaxBoundsData dealt = new MinMaxBoundsData();
    private MinMaxBoundsData taken = new MinMaxBoundsData();

    public DamagePredicate buildDamagePredicate() {
        return new DamagePredicate(this.dealt.buildBounds(), this.taken.buildBounds(), this.getEntityData().buildPredicate(), this.blocked, this.getDamageSourceData().buildPredicate());
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max damage dealt.")
    public void setDealtMinMax(float min, float max) {
        this.dealt.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min damage dealt.")
    public void setDealtMin(float min) {
        this.dealt.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max damage dealt.")
    public void setDealtMax(float max) {
        this.dealt.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max damage taken.")
    public void setTakenMinMax(float min, float max) {
        this.taken.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min damage taken.")
    public void setTakenMin(float min) {
        this.taken.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max damage taken.")
    public void setTakenMax(float max) {
        this.taken.setMax(max);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the DamageSourceData object so functions can be called on it.")
    public DamageSourceData getDamageSourceData() {
        if (this.damageSourceData == null) {
            this.damageSourceData = new DamageSourceData();
        }
        return this.damageSourceData;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object so functions can be called on it.")
    public EntityData getEntityData() {
        if (this.entityData == null) {
            this.entityData = new EntityData();
        }
        return this.entityData;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage was blocked.")
    public void setBlocked(boolean bool) {
        this.blocked = bool;
    }
}

