/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config;

import com.bloodnbonesgaming.lib.util.FileHelper;
import com.bloodnbonesgaming.lib.util.script.ScriptDocumentationHandler;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.CompletedAdvancementData;
import com.bloodnbonesgaming.triumph.advancements.display.VisibilityOption;
import com.bloodnbonesgaming.triumph.config.DefaultConfigs;
import com.bloodnbonesgaming.triumph.config.IOHelper;
import com.bloodnbonesgaming.triumph.config.MainConfig;
import com.bloodnbonesgaming.triumph.config.data.AdvancementData;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.FunctionObject;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ConfigurationManager {
    private static MainConfig mainConfig;

    public static MainConfig getMainConfig() {
        return mainConfig;
    }

    public static void init() {
        ConfigurationManager.loadMainConfig();
        ConfigurationManager.handleDefaultConfigsAndDocumentation();
    }

    public static void loadMainConfig() {
        Triumph.instance.getLog().info((Object)"Attempting to read config Triumph.txt");
        MainConfig mainConfig = new MainConfig();
        boolean canceled = IOHelper.loadMainConfig(mainConfig);
        ConfigurationManager.mainConfig = !canceled ? mainConfig : new MainConfig();
    }

    public static void reloadFunctions() {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_193030_aL().func_193059_f();
    }

    public static void handleDefaultConfigsAndDocumentation() {
        if (mainConfig.shouldPrintDocumentation()) {
            Triumph.instance.getLog().info((Object)"Printing documentation to ./config/triumph/documentation/");
            ScriptDocumentationHandler.printAnnotatedDocumentation((String)"com.bloodnbonesgaming.triumph");
            ScriptDocumentationHandler.copyDocumentationFolder(ConfigurationManager.class, (String)"./config/triumph/documentation/");
        }
        if (mainConfig.shouldPrintDefaultConfigs()) {
            Triumph.instance.getLog().info((Object)"Printing default configs.");
            DefaultConfigs.printDefaultConfigs();
            ConfigurationManager.loadMainConfig();
            ConfigurationManager.handleDefaultConfigsAndDocumentation();
        }
    }

    public static void removeModAdvancements(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        String[] removeAdvancements;
        int i;
        String[] keepAdvancements;
        if (mainConfig.shouldRemoveModAdvancements()) {
            Triumph.instance.getLog().info((Object)"Removing Mod Advancements");
            Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = advancementMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
                if (entry.getKey().func_110624_b().equals("minecraft")) continue;
                iterator.remove();
            }
        }
        if ((keepAdvancements = mainConfig.getKeepAdvancements()).length > 0) {
            Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = advancementMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
                boolean remove = true;
                for (i = 0; i < keepAdvancements.length; ++i) {
                    if (!keepAdvancements[i].equals(entry.getKey().func_110624_b()) && !keepAdvancements[i].equals(entry.getKey().toString())) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                iterator.remove();
            }
        }
        if ((removeAdvancements = mainConfig.getRemoveAdvancements()).length > 0) {
            Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = advancementMap.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
                for (i = 0; i < removeAdvancements.length; ++i) {
                    if (!removeAdvancements[i].equals(entry.getKey().func_110624_b()) && !removeAdvancements[i].equals(entry.getKey().toString())) continue;
                    iterator.remove();
                    continue block3;
                }
            }
        }
    }

    public static void loadAdvancments(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        Triumph.instance.getLog().info((Object)"Loading Custom Advancements");
        ConfigurationManager.loadScriptAdvancments(advancementMap);
        ConfigurationManager.loadJsonAdvancements(advancementMap);
    }

    public static void loadScriptAdvancments(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        File scriptFolder = new File("./config/triumph/script/");
        if (!scriptFolder.exists()) {
            scriptFolder.mkdirs();
            scriptFolder.mkdir();
        }
        ArrayList<AdvancementData> advancements = new ArrayList<AdvancementData>();
        ArrayList<AdvancementData> roots = new ArrayList<AdvancementData>();
        try (Stream<Path> walk = Files.walk(Paths.get("./config/triumph/script/", new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".txt"));){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Iterator<VisibilityOption> scriptFile;
                Path path = (Path)it.next();
                String filePath = ((File)((Object)(scriptFile = path.toFile()))).getPath();
                String string = filePath.substring("./config/triumph/script/".length(), filePath.length() - 4).replace("\\", "/");
                String[] splitLocation = string.split("/", 2);
                String location = splitLocation.length == 2 ? splitLocation[0].toLowerCase() + ":" + splitLocation[1].toLowerCase() : "triumph:" + splitLocation[0].toLowerCase();
                AdvancementData data = new AdvancementData(location);
                boolean canceled = IOHelper.readAdvancementData(scriptFile, data);
                if (canceled) continue;
                if (data.getParent() == null) {
                    roots.add(data);
                }
                advancements.add(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (AdvancementData root : roots) {
            List<VisibilityOption> options = root.getPageVisibilityOptions();
            if (!root.doesPageRequireRoot() && options.isEmpty()) continue;
            List<AdvancementData> children = ConfigurationManager.findAllChildrenOfRoot(root.advancementID, new ArrayList<AdvancementData>(advancements));
            for (AdvancementData child : children) {
                if (root.doesPageRequireRoot()) {
                    child.requireRoot(root.advancementID);
                }
                for (VisibilityOption option : options) {
                    child.addVisibilityOption(option);
                }
            }
            for (VisibilityOption option : options) {
                root.addVisibilityOption(option);
            }
        }
        for (AdvancementData data : advancements) {
            AdvancementData parent;
            if (data.requiresParents && data.getParent() != null && (parent = ConfigurationManager.getAdvancement(advancements, data.getParent())) != null) {
                if (!ConfigurationManager.getMainConfig().useNewNames()) {
                    CompletedAdvancementData parentData = (CompletedAdvancementData)data.addCriteria("completedParent", "triumph:completed_advancement");
                    parentData.setAdvancement(data.getParent());
                    ArrayList<String> exceptions = new ArrayList<String>();
                    exceptions.add("completedParent");
                    int parentNumber = 1;
                    for (ResourceLocation location : data.getDisplayData().getExtraConnections()) {
                        String name = "completedParent" + ++parentNumber;
                        CompletedAdvancementData advData = (CompletedAdvancementData)data.addCriteria(name, "triumph:completed_advancement");
                        advData.setAdvancement(location.toString());
                        exceptions.add(name);
                    }
                    data.exceptionRequirements = exceptions.toArray(new String[0]);
                } else {
                    ArrayList<String> exceptions = new ArrayList<String>();
                    if (parent.getDisplayData().buildTitle() != null) {
                        ITextComponent title = parent.getDisplayData().buildTitle();
                        CompletedAdvancementData parentData = (CompletedAdvancementData)data.addCriteria("Completed " + title.func_150260_c(), "triumph:completed_advancement");
                        parentData.setAdvancement(data.getParent());
                        exceptions.add("Completed " + title.func_150260_c());
                    } else {
                        CompletedAdvancementData parentData = (CompletedAdvancementData)data.addCriteria("Completed " + data.getParent(), "triumph:completed_advancement");
                        parentData.setAdvancement(data.getParent());
                        exceptions.add("Completed " + data.getParent());
                    }
                    for (ResourceLocation location : data.getDisplayData().getExtraConnections()) {
                        parent = ConfigurationManager.getAdvancement(advancements, location.toString());
                        if (parent == null) continue;
                        if (parent.getDisplayData().buildTitle() != null) {
                            ITextComponent title = parent.getDisplayData().buildTitle();
                            CompletedAdvancementData advData = (CompletedAdvancementData)data.addCriteria("Completed " + title.func_150260_c(), "triumph:completed_advancement");
                            advData.setAdvancement(location.toString());
                            exceptions.add("Completed " + title.func_150260_c());
                            continue;
                        }
                        CompletedAdvancementData advData = (CompletedAdvancementData)data.addCriteria("Completed " + location.toString(), "triumph:completed_advancement");
                        advData.setAdvancement(location.toString());
                        exceptions.add("Completed " + location.toString());
                    }
                    data.exceptionRequirements = exceptions.toArray(new String[0]);
                }
            }
            ResourceLocation advancementName = new ResourceLocation(data.advancementID);
            try {
                Advancement.Builder builder = data.makeBuilder(advancementName);
                if (builder != null) {
                    advancementMap.put(advancementName, builder);
                    continue;
                }
                Triumph.instance.getLog().error((Object)("Could not build Advancement.Builder for " + data.advancementID + ". It will not be added."));
            }
            catch (Exception e) {
                Triumph.instance.getLog().error((Object)("Could not build advancement " + advancementName + ": " + e.getLocalizedMessage()));
            }
        }
    }

    public static void loadJSAdvancments(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        File scriptFolder = new File("./config/triumph/js/");
        if (!scriptFolder.exists()) {
            scriptFolder.mkdirs();
            scriptFolder.mkdir();
        }
        ScriptEngineManager factory = new ScriptEngineManager(null);
        try (Stream<Path> walk = Files.walk(Paths.get("./config/triumph/js/", new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".txt"));){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                File scriptFile = path.toFile();
                String filePath = scriptFile.getPath();
                String string = filePath.substring("./config/triumph/js/".length(), filePath.length() - 4).replace("\\", "/");
                String[] splitLocation = string.split("/", 2);
                String location = splitLocation.length == 2 ? splitLocation[0] + ":" + splitLocation[1] : "triumph:" + splitLocation[0];
                AdvancementData data = new AdvancementData(location);
                ScriptEngine engine = factory.getEngineByName("nashorn");
                try (BufferedReader reader = FileHelper.openReader((File)scriptFile);){
                    engine.put("setIcon", data::setIcon);
                    engine.put("setTitle", data::setTitle);
                    engine.put("setDescription", data::setDescription);
                    engine.put("addParent", data::addParent);
                    engine.put("setPos", data::setPos);
                    engine.put("hideLines", data::hideLines);
                    engine.put("addCriteria", data::addCriteria);
                    engine.eval(reader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ResourceLocation advancementName = new ResourceLocation(location);
                try {
                    Advancement.Builder builder = data.makeBuilder(advancementName);
                    if (builder != null) {
                        advancementMap.put(advancementName, builder);
                        continue;
                    }
                    Triumph.instance.getLog().error((Object)("Could not build Advancement.Builder for " + location + ". It will not be added."));
                }
                catch (Exception e) {
                    Triumph.instance.getLog().error((Object)("Could not build advancement " + advancementName + ": " + e.getLocalizedMessage()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadJsonAdvancements(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        File jsonFolder = new File("./config/triumph/json/");
        if (!jsonFolder.exists()) {
            jsonFolder.mkdirs();
            jsonFolder.mkdir();
        }
        try (Stream<Path> walk = Files.walk(Paths.get("./config/triumph/json/", new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".json"));){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                File jsonFile = path.toFile();
                BufferedReader reader = FileHelper.openReader((File)jsonFile);
                Advancement.Builder builder = (Advancement.Builder)JsonUtils.func_193839_a((Gson)AdvancementManager.field_192783_b, (Reader)reader, Advancement.Builder.class);
                if (builder != null) {
                    String filePath = jsonFile.getPath();
                    String sub = filePath.substring(22, filePath.length() - 5).replace("\\", "/");
                    String[] splitLocation = sub.split("/", 2);
                    String location = splitLocation.length == 2 ? splitLocation[0] + ":" + splitLocation[1] : "triumph:" + splitLocation[0];
                    advancementMap.put(new ResourceLocation(location), builder);
                }
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadFunctions(FunctionManager manager, Map<ResourceLocation, FunctionObject> functionMap) {
        Triumph.instance.getLog().info((Object)"Loading Custom Functions");
        String folder = "./config/triumph/functions/";
        String extension = ".txt";
        File functionFolder = new File("./config/triumph/functions/");
        if (!functionFolder.exists()) {
            functionFolder.mkdirs();
            functionFolder.mkdir();
        }
        try (Stream<Path> walk = Files.walk(Paths.get("./config/triumph/functions/", new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".txt"));){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                File functionFile = path.toFile();
                String filePath = functionFile.getPath();
                String sub = filePath.substring("./config/triumph/functions/".length(), filePath.length() - ".txt".length()).replace("\\", "/");
                String[] splitLocation = sub.split("/", 2);
                String location = splitLocation.length == 2 ? splitLocation[0] + ":" + splitLocation[1] : "triumph:" + splitLocation[0];
                ResourceLocation functionName = new ResourceLocation(location);
                try {
                    functionMap.put(functionName, FunctionObject.func_193527_a((FunctionManager)manager, (List)com.google.common.io.Files.readLines((File)functionFile, (Charset)StandardCharsets.UTF_8)));
                }
                catch (Exception e) {
                    Triumph.instance.getLog().info((Object)("Failed to add function " + functionName + " because: " + e.getLocalizedMessage()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<AdvancementData> findAllChildrenOfRoot(String root, List<AdvancementData> advancements) {
        ArrayList<AdvancementData> children = new ArrayList<AdvancementData>();
        ArrayList<String> childNames = new ArrayList<String>();
        while (!advancements.isEmpty()) {
            boolean foundChild = false;
            Iterator<AdvancementData> iterator = advancements.iterator();
            block1: while (iterator.hasNext()) {
                AdvancementData advancement = iterator.next();
                if (advancement.getParent() == null) continue;
                if (advancement.getParent().equals(root) || childNames.contains(advancement.getParent())) {
                    children.add(advancement);
                    childNames.add(advancement.advancementID);
                    iterator.remove();
                    foundChild = true;
                    continue;
                }
                for (ResourceLocation location : advancement.getDisplayData().getExtraConnections()) {
                    String parent = location.toString();
                    if (!parent.equals(root) && !childNames.contains(parent)) continue;
                    children.add(advancement);
                    childNames.add(advancement.advancementID);
                    iterator.remove();
                    foundChild = true;
                    continue block1;
                }
            }
            if (foundChild) continue;
            break;
        }
        return children;
    }

    private static AdvancementData getAdvancement(List<AdvancementData> advancements, String id) {
        for (AdvancementData data : advancements) {
            if (!data.advancementID.equals(id)) continue;
            return data;
        }
        return null;
    }
}

