/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.data;

import com.google.common.base.CaseFormat;
import com.timwoodcreates.roost.RoostItems;
import com.timwoodcreates.roost.data.DataChickenModded;
import com.timwoodcreates.roost.data.DataChickenVanilla;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class DataChicken {
    public static final String CHICKEN_ID_KEY = "Chicken";
    private static final Pattern REMOVE_CHICKENS_PREFIX = Pattern.compile("_?chick(en)?s?_?");
    private String name;
    protected String i18nName;
    protected Random rand = new Random();

    public static List<DataChicken> getAllChickens() {
        LinkedList<DataChicken> chickens = new LinkedList<DataChicken>();
        DataChickenVanilla.addAllChickens(chickens);
        if (Loader.isModLoaded((String)"chickens")) {
            DataChickenModded.addAllChickens(chickens);
        }
        return chickens;
    }

    public static DataChicken getDataFromTooltipNBT(NBTTagCompound tag) {
        if (tag == null) {
            return null;
        }
        DataChicken data = null;
        if (Loader.isModLoaded((String)"chickens")) {
            data = DataChickenModded.getDataFromTooltipNBT(tag);
        }
        if (data == null) {
            data = DataChickenVanilla.getDataFromTooltipNBT(tag);
        }
        return data;
    }

    public static DataChicken getDataFromEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        DataChicken data = null;
        if (Loader.isModLoaded((String)"chickens")) {
            data = DataChickenModded.getDataFromEntity(entity);
        }
        if (data == null) {
            data = DataChickenVanilla.getDataFromEntity(entity);
        }
        return data;
    }

    public static DataChicken getDataFromStack(ItemStack stack) {
        if (!DataChicken.isChicken(stack)) {
            return null;
        }
        DataChicken data = null;
        if (Loader.isModLoaded((String)"chickens")) {
            data = DataChickenModded.getDataFromStack(stack);
        }
        if (data == null) {
            data = DataChickenVanilla.getDataFromStack(stack);
        }
        return data;
    }

    public static void getItemChickenSubItems(CreativeTabs tab, List<ItemStack> subItems) {
        for (DataChicken chicken : DataChicken.getAllChickens()) {
            subItems.add(chicken.buildChickenStack());
        }
    }

    public static boolean isChicken(ItemStack stack) {
        return stack.func_77973_b() == RoostItems.ITEM_CHICKEN;
    }

    public DataChicken(String name, String i18nName) {
        String cleanedName;
        String underscoredName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        this.name = cleanedName = REMOVE_CHICKENS_PREFIX.matcher(underscoredName).replaceAll("");
        this.i18nName = i18nName;
    }

    public void addInfoToTooltip(List<String> tooltip) {
    }

    public boolean hasParents() {
        return false;
    }

    public List<ItemStack> buildParentChickenStack() {
        return null;
    }

    public ItemStack buildChickenStack() {
        return ItemStack.field_190927_a;
    }

    public ItemStack buildCaughtFromStack() {
        return ItemStack.field_190927_a;
    }

    public EntityChicken buildEntity(World world) {
        return null;
    }

    public NBTTagCompound buildTooltipNBT() {
        return null;
    }

    public void spawnEntity(World world, BlockPos pos) {
    }

    private static ItemStack createChildStack(DataChicken chickenA, DataChicken chickenB, World world) {
        if (chickenA.getClass() != chickenB.getClass()) {
            return chickenA.buildChickenStack();
        }
        EntityChicken parentA = chickenA.buildEntity(world);
        EntityChicken parentB = chickenB.buildEntity(world);
        if (parentA == null || parentB == null) {
            return ItemStack.field_190927_a;
        }
        DataChicken childData = DataChicken.getDataFromEntity((Entity)parentA.func_90011_a((EntityAgeable)parentB));
        if (childData == null) {
            return ItemStack.field_190927_a;
        }
        return childData.buildChickenStack();
    }

    public ItemStack createChildStack(DataChicken other, World world) {
        if (this.rand.nextBoolean()) {
            return DataChicken.createChildStack(this, other, world);
        }
        return DataChicken.createChildStack(other, this, world);
    }

    public ItemStack createDropStack() {
        return ItemStack.field_190927_a;
    }

    public int getAddedTime(ItemStack stack) {
        return Math.max(0, stack.func_190916_E());
    }

    public int getLayTime() {
        return 6000 + this.rand.nextInt(6000);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return I18n.func_135052_a((String)this.i18nName, (Object[])new Object[0]);
    }

    public boolean isEqual(DataChicken other) {
        return true;
    }

    public String getDisplaySummary() {
        return this.getDisplayName();
    }
}

