/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items;

import com.blakebr0.mysticalagriculture.items.ItemBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMeta
extends ItemBase {
    public Map<Integer, MetaItem> items = new HashMap<Integer, MetaItem>();
    public ArrayList<Integer> metas = new ArrayList();
    public List<String> tooltip = new ArrayList<String>();

    public ItemMeta(String name) {
        super(name);
        this.func_77627_a(true);
    }

    public ItemStack addItem(int meta, String name, boolean enabled) {
        if (!enabled) {
            return null;
        }
        if (this.items.containsKey(meta)) {
            return null;
        }
        this.items.put(meta, new MetaItem(name, enabled));
        this.metas.add(meta);
        return new ItemStack((Item)this, 1, meta);
    }

    public ItemStack addItem(int meta, String name, boolean enabled, List<String> tooltip) {
        if (!enabled) {
            return null;
        }
        if (this.items.containsKey(meta)) {
            return null;
        }
        this.items.put(meta, new MetaItem(name, enabled, tooltip));
        this.metas.add(meta);
        return new ItemStack((Item)this, 1, meta);
    }

    public ItemStack addItem(int meta, String name) {
        return this.addItem(meta, name, true);
    }

    public ItemStack addItem(int meta, String name, String ore, boolean enabled) {
        ItemStack stack = this.addItem(meta, name, enabled);
        OreDictionary.registerOre((String)ore, (ItemStack)stack);
        return stack;
    }

    public ItemStack addItem(int meta, String name, String ore, boolean enabled, List<String> tooltip) {
        ItemStack stack = this.addItem(meta, name, enabled, tooltip);
        OreDictionary.registerOre((String)ore, (ItemStack)stack);
        return stack;
    }

    public ItemStack addItem(int meta, String name, String ore) {
        return this.addItem(meta, name, ore, true);
    }

    public void getSubItems(Item item, CreativeTabs tab, List<ItemStack> stacks) {
        for (int meta : this.metas) {
            stacks.add(new ItemStack(item, 1, meta));
        }
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        if (!this.items.containsKey(i)) {
            return "invalid";
        }
        MetaItem item = this.items.get(i);
        return this.func_77658_a() + "_" + item.getName();
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        MetaItem item;
        int i = stack.func_77960_j();
        if (this.items.containsKey(i) && (item = this.items.get(i)).getTooltip() != null && !item.getTooltip().isEmpty()) {
            tooltip.addAll(item.getTooltip());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels() {
        for (Map.Entry<Integer, MetaItem> item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)item.getKey(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_" + item.getValue().getName()));
        }
    }

    public void init() {
    }

    public class MetaItem {
        private String name;
        private boolean enabled;
        private List<String> tooltip;

        MetaItem(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        MetaItem(String name, boolean enabled, List<String> tooltip) {
            this.name = name;
            this.enabled = enabled;
            this.tooltip = tooltip;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<String> getTooltip() {
            return this.tooltip;
        }
    }
}

