/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm.client.gui;

import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.util.MathHelper;
import xt9.deepmoblearningbm.DeepMobLearningBM;
import xt9.deepmoblearningbm.ModConfig;
import xt9.deepmoblearningbm.client.gui.buttons.AlertInformationZone;
import xt9.deepmoblearningbm.client.gui.buttons.ClickableZoneButton;
import xt9.deepmoblearningbm.client.gui.buttons.ZoneButton;
import xt9.deepmoblearningbm.common.inventory.ContainerDigitalAgonizer;
import xt9.deepmoblearningbm.common.network.HighlightAltarMessage;
import xt9.deepmoblearningbm.common.tile.TileEntityDigitalAgonizer;

public class DigitalAgonizerGui
extends GuiContainer {
    private static final ResourceLocation defaultGui = new ResourceLocation("deepmoblearningbm", "textures/gui/default_gui.png");
    private static final ResourceLocation base = new ResourceLocation("deepmoblearningbm", "textures/gui/digital_agonizer_gui.png");
    private TileEntityDigitalAgonizer tile;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 178;
    private DeepEnergyStorage energyStorage;
    private ZoneButton sacRuneZone;
    private ClickableZoneButton altarButton;
    private AlertInformationZone alertButton;
    private NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);

    public DigitalAgonizerGui(TileEntityDigitalAgonizer tile, InventoryPlayer inventory, World world) {
        super((Container)new ContainerDigitalAgonizer(tile, inventory, world));
        this.tile = tile;
        this.field_146999_f = 200;
        this.field_147000_g = 178;
        this.energyStorage = (DeepEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.sacRuneZone = new ZoneButton(0, this.getGuiLeft() + 120, this.getGuiTop() - 8, 16, 16, this.field_146294_l, this.field_146295_m);
        this.altarButton = new ClickableZoneButton(1, this.getGuiLeft() + 130, this.getGuiTop() + 35, 16, 16, this.field_146294_l, this.field_146295_m);
        this.alertButton = new AlertInformationZone(2, this.getGuiLeft() + 114, this.getGuiTop() + 79, 16, 16, this.field_146294_l, this.field_146295_m);
        this.field_146292_n.add(this.sacRuneZone);
        this.field_146292_n.add(this.altarButton);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.field_146292_n.forEach(guiButton -> {
            if (guiButton.func_146115_a()) {
                this.handleButtonClick((GuiButton)guiButton);
            }
        });
    }

    private void handleButtonClick(GuiButton guiButton) {
        if (guiButton.field_146127_k == this.altarButton.field_146127_k && this.tile.getAltarTank() != null) {
            DeepMobLearningBM.network.sendToServer((IMessage)new HighlightAltarMessage());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        ArrayList<String> energyTooltip = new ArrayList<String>();
        if (17 <= y && y < 66 && 52 <= x && x < 59) {
            energyTooltip.add(this.f.format(this.energyStorage.getEnergyStored()) + "/" + this.f.format(this.energyStorage.getMaxEnergyStored()) + " RF");
            energyTooltip.add("Operational cost: " + this.f.format(ModConfig.getAgonizerRFCost()) + " RF/t");
            this.func_146283_a(energyTooltip, x, y);
        }
        ArrayList<String> runeTooltips = new ArrayList<String>();
        ArrayList<String> altarTooltip = new ArrayList<String>();
        ArrayList<String> alertTooltips = new ArrayList<String>();
        if (this.tile.getAltarTank() != null) {
            BloodAltar altar = this.tile.getAltarTank();
            runeTooltips.add("Altar has " + this.tile.getNumOfSacrificeRunes() + " sacrifice runes.");
            runeTooltips.add("Rune multiplier: " + altar.getSacrificeMultiplier() + "x");
            runeTooltips.add("Catalyst multiplier: " + this.tile.getMultiplier() + "x");
            runeTooltips.add("Final multiplier: " + this.f.format(this.tile.getMultiplier() + this.tile.getSacrificeMultiplier()) + "x");
            altarTooltip.add("Linked to altar at position");
            altarTooltip.add("x: " + this.tile.getAltarPos().func_177958_n() + ", y: " + this.tile.getAltarPos().func_177956_o() + ", z: " + this.tile.getAltarPos().func_177952_p() + "");
            altarTooltip.add("Tank: " + this.f.format(altar.getFluidAmount()) + "/" + this.f.format(altar.getCapacity()) + "mB");
            altarTooltip.add("");
            altarTooltip.add("\u00a7oClick icon to reveal altar\u00a7r");
            altarTooltip.add("\u00a7oposition for 20 seconds.\u00a7r");
        } else {
            altarTooltip.add("No linked altar!");
            altarTooltip.add("Use the Altar Linker to link this");
            altarTooltip.add("machine to an Altar.");
        }
        alertTooltips.add("\u00a7cIssues\u00a7r");
        if (!this.tile.hasDataModel()) {
            alertTooltips.add("- No Data Model");
        }
        if (this.tile.hasDataModel() && !this.tile.isValidDataModelTier()) {
            alertTooltips.add("- Data Model Tier too low");
        }
        if (this.tile.getAltarTank() == null) {
            alertTooltips.add("- No linked Altar");
        }
        this.sacRuneZone.setTooltip(runeTooltips);
        this.altarButton.setTooltip(altarTooltip);
        this.alertButton.setTooltip(alertTooltips);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left + 46, top + 12, 0, 0, 107, 59);
        int craftingBarWidth = (int)((float)this.tile.getProgress() / 60.0f * 36.0f);
        this.func_73729_b(left + 88, top + 39, 25, 59, craftingBarWidth, 6);
        int energyBarHeight = MathHelper.ensureRange((int)((int)((float)this.energyStorage.getEnergyStored() / (float)(this.energyStorage.getMaxEnergyStored() - ModConfig.getAgonizerRFCost()) * 49.0f)), (int)0, (int)49);
        int energyBarOffset = 49 - energyBarHeight;
        this.func_73729_b(left + 52, top + 17 + energyBarOffset, 0, 59, 7, energyBarHeight);
        this.func_73729_b(left + 91, top + 78, 7, 59, 18, 18);
        if (this.tile.getAltarTank() == null) {
            this.func_73729_b(left + 129, top + 35, 60, 59, 15, 15);
        } else {
            this.drawItemStack(left + 130, top + 34, new ItemStack(RegistrarBloodMagicBlocks.ALTAR));
            this.drawItemStack(left + 120, top - 8, new ItemStack(RegistrarBloodMagicBlocks.BLOOD_RUNE, 1, 3));
            this.func_73731_b(this.field_146289_q, this.tile.getNumOfSacrificeRunes() + "", left + 140, top - 4, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, this.f.format(this.tile.getMultiplier() + this.tile.getSacrificeMultiplier()) + "x", left + 105, top + 28, 0xFFFFFF);
        if (this.tile.hasDataModel() && this.tile.isValidDataModelTier()) {
            this.func_73732_a(this.field_146289_q, this.tile.getFillAmount() + "mB", left + 105, top + 49, 0xFFFFFF);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(defaultGui);
        this.func_73729_b(left + 12, top + 106, 0, 0, 176, 90);
        this.func_73733_a(left + 66, top + 31, left + 82, top + 33, -12434878, -13421773);
        int catalystWidth = (int)((float)this.tile.getCatalystOperations() / (float)this.tile.getCatalystOperationsMax() * 16.0f);
        this.func_73733_a(left + 66, top + 31, left + 66 + catalystWidth, top + 33, -6208780, -8049453);
        this.field_146292_n.forEach(guiButton -> guiButton.func_191745_a(this.field_146297_k, mouseX, mouseY, this.field_146297_k.func_184121_ak()));
        if (!this.tile.hasDataModel() || this.tile.hasDataModel() && !this.tile.isValidDataModelTier() || this.tile.getAltarTank() == null) {
            this.alertButton.func_191745_a(this.field_146297_k, mouseX, mouseY, this.field_146297_k.func_184121_ak());
        }
    }

    private void drawItemStack(int x, int y, ItemStack stack) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 1.0f;
        this.field_146296_j.field_77023_b = 1.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
    }
}

