/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.client.gui.widgets.ITooltip;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFluidTank
extends GuiButton
implements ITooltip {
    private final IAEFluidTank tank;
    private final int slot;

    public GuiFluidTank(IAEFluidTank tank, int slot, int id, int x, int y, int w, int h) {
        super(id, x, y, w, h, "");
        this.tank = tank;
        this.slot = slot;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179140_f();
            GuiFluidTank.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)(AEColor.GRAY.blackVariant | 0xFF000000));
            IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
            if (fluid != null && fluid.getStackSize() > 0L) {
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float red = (float)(fluid.getFluid().getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluid.getFluid().getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluid.getFluid().getColor() & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
                int scaledHeight = (int)((float)this.field_146121_g * ((float)fluid.getStackSize() / (float)this.tank.getTankProperties()[this.slot].getCapacity()));
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    this.func_175175_a(this.field_146128_h, this.field_146129_i + this.field_146121_g - iconHeightRemainder, sprite, 16, iconHeightRemainder);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    this.func_175175_a(this.field_146128_h, this.field_146129_i + this.field_146121_g - iconHeightRemainder - (i + 1) * 16, sprite, 16, 16);
                }
            }
        }
    }

    @Override
    public String getMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            String desc = fluid.getFluid().getLocalizedName(fluid.getFluidStack());
            String amountToText = fluid.getStackSize() + "mB";
            return desc + "\n" + amountToText;
        }
        return null;
    }

    @Override
    public int xPos() {
        return this.field_146128_h - 2;
    }

    @Override
    public int yPos() {
        return this.field_146129_i - 2;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f + 4;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g + 4;
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

