/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.shape.AsymmetricalShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PyramidIsoscelesTriangular
extends AsymmetricalShape {
    private float offsetCenter;
    private float center1Inset;
    private float center2Inset;
    private float insetMin;
    private float insetMax;
    private float insetMin2;
    private float insetMax2;
    private float height;
    private float cInset2;
    private boolean isTwisted;
    private boolean isFlipped;

    @Override
    public void init(float centerX, float centerY, float centerZ, float a, float b, float c, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        float h;
        int rotation = direction / 6;
        super.init(centerX, centerY, centerZ, a, b, c, direction %= 6, sculptHollowShape, wallThickness, openEnds);
        boolean bl = this.isTwisted = rotation % 2 == (direction > 3 ? 0 : 1);
        boolean bl2 = rotation % 2 == 0 ? direction % 2 == (rotation == 0 ? 0 : 1) : (rotation == 1 ? direction != 2 && direction != 3 : (this.isFlipped = direction == 2 || direction == 3));
        if (this.isEquilateral) {
            float s;
            float contract;
            if (this.isTwisted) {
                contract = this.a - this.a * (float)Math.cos(0.523599);
                this.centerX -= this.inverted != this.isFlipped ? -contract : contract;
                this.a -= contract;
                this.aInset = this.reduceLength(this.a);
                s = this.a - this.a / 3.0f;
                h = this.a * 2.0f;
            } else {
                contract = this.c - this.c * (float)Math.cos(0.523599);
                this.centerZ -= this.inverted != this.isFlipped ? -contract : contract;
                this.c -= contract;
                this.cInset = this.reduceLength(this.c);
                s = this.c - this.c / 3.0f;
                h = this.c * 2.0f;
            }
            contract = this.b - (float)Math.sqrt(h * h - s * s) * 0.5f;
            this.centerY -= this.inverted ? -contract : contract;
            this.b -= contract;
            this.bInset = this.reduceLength(this.b);
        }
        b = this.b;
        float bInset = this.bInset;
        centerY = this.centerY;
        if (this.isTwisted) {
            a = this.c;
            c = this.a;
            centerZ = this.centerX;
        } else {
            a = this.a;
            c = this.c;
            centerZ = this.centerZ;
        }
        this.height = b * 2.0f;
        float hsq = this.height * this.height;
        this.cInset2 = b - (float)(Math.sqrt(c * c + hsq) * (double)wallThickness / (double)c);
        this.insetMax = centerY + bInset;
        this.insetMin = centerY - bInset;
        if (a <= c) {
            this.offsetCenter = c / 3.0f;
        } else {
            h = c * 2.0f;
            hsq = h * h;
            float w = a * 2.0f;
            float wsq = w * w;
            this.offsetCenter = c - w * ((float)Math.sqrt(wsq + 4.0f * hsq) - w) / (4.0f * h);
        }
        Vec3d offset = this.getInnerTriangularPyramidOffset(centerY, centerZ, this.offsetCenter, a, b, c, wallThickness);
        float offsetZ = (float)(this.inverted ? -offset.field_72449_c : offset.field_72449_c);
        this.center1Inset = centerZ - (this.isFlipped ? -offsetZ : offsetZ);
        this.center2Inset = centerY - (float)(this.inverted ? -offset.field_72448_b : offset.field_72448_b);
        if (this.isFlipped) {
            this.offsetCenter *= -1.0f;
        }
        this.insetMax2 = this.center2Inset + b;
        this.insetMin2 = this.center2Inset - b;
    }

    private Vec3d getInnerTriangularPyramidOffset(float centerY, float centerZ, float offsetCenter, float a, float b, float c, float wallThickness) {
        float s1 = c - offsetCenter;
        float h1 = b * 2.0f;
        float a1 = (float)Math.atan(s1 / h1);
        float p1 = (float)Math.sqrt(s1 * s1 + h1 * h1) * wallThickness / s1;
        float s2 = a;
        float a2 = 1.5708f - (float)Math.atan((c + offsetCenter) / h1);
        float h2 = (float)(Math.sqrt(s2 * s2 + h1 * h1) * Math.cos(a1 - a2));
        float p2 = (float)Math.sqrt(s2 * s2 + h2 * h2) * wallThickness / s2;
        float dy = (float)(Math.cos(a2) * (double)p2);
        float dz = (float)(Math.sin(a2) * (double)p2);
        float apexZ = centerZ - offsetCenter;
        float apexY = centerY + b;
        float z1 = centerZ - c;
        float y1 = centerY - b - p1;
        float z2 = apexZ;
        float y2 = apexY - p1;
        float z3 = apexZ - dz;
        float y3 = apexY - dy;
        float z4 = centerZ + c - dz;
        float y4 = centerY - b - dy;
        float m1 = (y2 - y1) / (z2 - z1);
        float b1 = y1 - m1 * z1;
        float m2 = (y4 - y3) / (z4 - z3);
        float b2 = y3 - m2 * z3;
        float interZ = (b2 - b1) / (m1 - m2);
        float interY = m1 * interZ + b1;
        return new Vec3d(0.0, (double)(apexY - interY), (double)(apexZ - interZ));
    }

    @Override
    public boolean isPointInsideShape(BlockPos pos, int i, int j, int k) {
        float y = this.getBitPosY(pos, i, j, k);
        if (this.isPointOffLine(y, this.centerY, this.b)) {
            return false;
        }
        float x = this.getBitPosX(pos, i, j);
        float z = this.getBitPosZ(pos, j, k);
        if (this.isTwisted) {
            boolean inShape = this.isPointInPyramid(y, z, x, this.centerX, this.centerY);
            return this.sculptHollowShape ? inShape && (!this.isPointInPyramid(y, z, x, this.center1Inset, this.center2Inset) || this.isPointOffLine(y)) : inShape;
        }
        boolean inShape = this.isPointInPyramid(y, x, z, this.centerZ, this.centerY);
        return this.sculptHollowShape ? inShape && (!this.isPointInPyramid(y, x, z, this.center1Inset, this.center2Inset) || this.isPointOffLine(y)) : inShape;
    }

    protected boolean isPointInPyramid(float val, float v1, float v2, float center1, float center2) {
        float dy = center2 - val;
        float h = dy + (this.inverted ? -this.b : this.b);
        float s1 = h * this.a / this.height;
        float s2 = h * this.c / this.height;
        if (this.isTwisted) {
            float s3 = (dy + (this.inverted ? -this.cInset2 : this.cInset2)) * this.a / this.height;
            float center = center1 + (this.inverted ? this.offsetCenter * (1.0f + s3 / this.a) : -this.offsetCenter * (1.0f - s3 / this.a));
            return this.isPointInTriangle(v1, v2, this.centerZ, center, s2, this.isFlipped ? -s1 : s1);
        }
        float s3 = (dy + (this.inverted ? -this.cInset2 : this.cInset2)) * this.c / this.height;
        float center = center1 + (this.inverted ? this.offsetCenter * (1.0f + s3 / this.c) : -this.offsetCenter * (1.0f - s3 / this.c));
        return this.isPointInTriangle(v1, v2, this.centerX, center, s1, this.isFlipped ? -s2 : s2);
    }

    protected boolean isPointOffLine(float val) {
        return this.inverted ? !this.openEnds && val > this.insetMax || val < this.insetMin2 : !this.openEnds && val < this.insetMin || val > this.insetMax2;
    }
}

