/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketBlockInteraction;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSculpt
extends PacketBlockInteraction
implements IMessage {
    private Vec3d drawnStartPoint;
    private BitToolSettingsHelper.SculptingData sculptingData = new BitToolSettingsHelper.SculptingData();

    public PacketSculpt() {
    }

    public PacketSculpt(BlockPos pos, EnumFacing side, Vec3d hit, Vec3d drawnStartPoint, BitToolSettingsHelper.SculptingData sculptingData) {
        super(pos, side, hit);
        this.drawnStartPoint = drawnStartPoint;
        this.sculptingData = sculptingData;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        if (BitIOHelper.notNullToBuffer(buffer, this.drawnStartPoint)) {
            buffer.writeDouble(this.drawnStartPoint.field_72450_a);
            buffer.writeDouble(this.drawnStartPoint.field_72448_b);
            buffer.writeDouble(this.drawnStartPoint.field_72449_c);
        }
        this.sculptingData.toBytes(buffer);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        if (buffer.readBoolean()) {
            this.drawnStartPoint = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        this.sculptingData.fromBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketSculpt, IMessage> {
        public IMessage onMessage(final PacketSculpt message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (ItemStackHelper.isSculptingToolStack(stack)) {
                        ((ItemSculptingTool)stack.func_77973_b()).sculptBlocks(stack, (EntityPlayer)player, player.field_70170_p, message.pos, message.side, message.hit, message.drawnStartPoint, message.sculptingData);
                    }
                }
            });
            return null;
        }
    }
}

