/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.ParticleSplashBit;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBitParticles
implements IMessage {
    private int flag;
    private Vec3d locBit;
    private Vec3d locEntity;
    private double width;
    private double height;

    public PacketBitParticles() {
    }

    public PacketBitParticles(int flag, @Nullable Entity entityBit, @Nullable Entity entity) {
        this.flag = flag;
        if (entityBit == null || entity == null) {
            this.locBit = new Vec3d(0.0, 0.0, 0.0);
            this.locEntity = new Vec3d(0.0, 0.0, 0.0);
            return;
        }
        double x = entityBit.field_70165_t;
        double y = entityBit.field_70163_u;
        double z = entityBit.field_70161_v;
        Vec3d start = new Vec3d(x, y, z);
        Vec3d end = new Vec3d(x + entityBit.field_70159_w, y + entityBit.field_70181_x, z + entityBit.field_70179_y);
        RayTraceResult result = entity.func_174813_aQ().func_186662_g((double)0.3f).func_72327_a(start, end);
        this.locBit = result != null ? result.field_72307_f : start;
        this.locEntity = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        this.width = (double)(flag == 0 ? entityBit.field_70130_N : entity.field_70130_N) + 0.2;
        this.height = (double)(flag == 0 ? entityBit.field_70131_O : entity.field_70131_O) + 0.2;
    }

    public PacketBitParticles(int flag, Vec3d locBit, BlockPos pos) {
        this(flag, null, (Entity)null);
        this.locBit = locBit;
        this.locEntity = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.flag);
        buffer.writeDouble(this.locBit.field_72450_a);
        buffer.writeDouble(this.locBit.field_72448_b);
        buffer.writeDouble(this.locBit.field_72449_c);
        buffer.writeDouble(this.locEntity.field_72450_a);
        buffer.writeDouble(this.locEntity.field_72448_b);
        buffer.writeDouble(this.locEntity.field_72449_c);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
    }

    public void fromBytes(ByteBuf buffer) {
        this.flag = buffer.readInt();
        this.locBit = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.locEntity = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
    }

    public static class Handler
    implements IMessageHandler<PacketBitParticles, IMessage> {
        public IMessage onMessage(final PacketBitParticles message, MessageContext ctx) {
            ClientHelper.getThreadListener().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    World world = ClientHelper.getWorld();
                    double width = message.width;
                    double height = message.height;
                    double x = ((PacketBitParticles)message).locBit.field_72450_a;
                    double y = ((PacketBitParticles)message).locBit.field_72448_b;
                    double z = ((PacketBitParticles)message).locBit.field_72449_c;
                    if (message.flag == 0) {
                        for (int i = 0; i < 3; ++i) {
                            double x2 = x - width * 0.5 + width * world.field_73012_v.nextDouble();
                            double y2 = y - height * 0.5 + height * world.field_73012_v.nextDouble();
                            double z2 = z - width * 0.5 + width * world.field_73012_v.nextDouble();
                            world.func_175688_a(EnumParticleTypes.FLAME, x2, y2, z2, 0.0, 0.0, 0.0, new int[0]);
                        }
                    } else if (message.flag == 3 || message.flag == 4) {
                        ParticleSplashBit.Factory particleFactory = new ParticleSplashBit.Factory();
                        for (int i = 0; i < 8; ++i) {
                            ClientHelper.spawnParticle(world, message.locBit, particleFactory);
                            if (message.flag != 4) continue;
                            world.func_175688_a(EnumParticleTypes.CLOUD, ((PacketBitParticles)message).locEntity.field_72450_a + Math.random(), ((PacketBitParticles)message).locEntity.field_72448_b + Math.random(), ((PacketBitParticles)message).locEntity.field_72449_c + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                        }
                    } else {
                        ParticleSplashBit.Factory particleFactory = new ParticleSplashBit.Factory();
                        for (int i = 0; i < 8; ++i) {
                            ClientHelper.spawnParticle(world, message.locBit, particleFactory);
                        }
                        if (message.flag != 2) {
                            return;
                        }
                        int count = MathHelper.func_76125_a((int)((int)(width * width * height * 6.25)), (int)1, (int)50);
                        for (int i = 0; i < count; ++i) {
                            ClientHelper.spawnParticle(world, message.locBit, particleFactory);
                            if (message.flag != 2) continue;
                            double x2 = ((PacketBitParticles)message).locEntity.field_72450_a - width * 0.5 + width * world.field_73012_v.nextDouble();
                            double y2 = ((PacketBitParticles)message).locEntity.field_72448_b + height * world.field_73012_v.nextDouble();
                            double z2 = ((PacketBitParticles)message).locEntity.field_72449_c - width * 0.5 + width * world.field_73012_v.nextDouble();
                            world.func_175688_a(EnumParticleTypes.CLOUD, x2, y2, z2, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            });
            return null;
        }
    }
}

