/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.item;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.KeyBindingsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.packet.PacketUseWrench;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.Cube;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemBitWrench
extends ItemBitToolBase {
    private static final String[] MODE_TITLES = new String[]{"Rotation", "Mirroring", "Translation", "Inversion"};
    public static final String[] MODE_TEXT = new String[]{"Rotate", "Mirror", "Translate", "Invert"};

    public ItemBitWrench(String name) {
        super(name);
    }

    public void cycleModes(ItemStack stack, boolean forward) {
        this.initialize(stack);
        NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
        nbt.func_74768_a("wrenchMode", BitToolSettingsHelper.cycleData(nbt.func_74762_e("wrenchMode"), forward, MODE_TITLES.length));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            this.useWrench(player.func_184586_b(hand), player, world, pos, side, Configs.oneBitTypeInversionRequirement, KeyBindingsExtraBitManipulation.SHIFT.isKeyDown());
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketUseWrench(pos, side, Configs.oneBitTypeInversionRequirement, KeyBindingsExtraBitManipulation.SHIFT.isKeyDown()));
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult useWrench(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, boolean oneBitTypeInversionRequirement, boolean invertDirection) {
        this.initialize(stack);
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        int mode = this.getMode(stack);
        if (api.isBlockChiseled(world, pos)) {
            int increment2;
            IBitAccess bitAccess;
            try {
                bitAccess = api.getBitAccess(world, pos);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                e.printStackTrace();
                return EnumActionResult.FAIL;
            }
            IBitBrush[][][] bitArray = new IBitBrush[16][16][16];
            int increment = 1;
            int s = (invertDirection ? (mode == 1 ? side.func_176732_a((side.func_176740_k().func_176722_c() ? EnumFacing.UP : player.func_174811_aO()).func_176740_k()) : side.func_176734_d()) : side).ordinal();
            boolean canTranslate = true;
            boolean canInvert = false;
            int bitCountEmpty = 0;
            int bitCountTake = 0;
            IBitBrush invertBit = null;
            ItemStack invertBitStack = ItemStack.field_190927_a;
            int removalLayer = s % 2 == 1 ? -1 : 16;
            boolean creativeMode = player.field_71075_bZ.field_75098_d;
            HashMap<IBlockState, Integer> inversionBitTypes = new HashMap<IBlockState, Integer>();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        IBitBrush bit;
                        bitArray[i][j][k] = bit = bitAccess.getBitAt(i, j, k);
                        boolean isAir = bit.isAir();
                        if (mode == 2) {
                            if (!isAir && (s == 4 && i == 16 - increment || s == 0 && j == 16 - increment || s == 2 && k == 16 - increment || s == 5 && i == increment - 1 || s == 1 && j == increment - 1 || s == 3 && k == increment - 1)) {
                                canTranslate = false;
                            }
                            if (isAir) continue;
                            if (s == 4 && i < removalLayer || s == 5 && i > removalLayer) {
                                removalLayer = i;
                                continue;
                            }
                            if (s == 0 && j < removalLayer || s == 1 && j > removalLayer) {
                                removalLayer = j;
                                continue;
                            }
                            if ((s != 2 || k >= removalLayer) && (s != 3 || k <= removalLayer)) continue;
                            removalLayer = k;
                            continue;
                        }
                        if (mode != 3) continue;
                        if (isAir) {
                            canInvert = true;
                            ++bitCountEmpty;
                            continue;
                        }
                        invertBit = bit;
                        IBlockState state = bit.getState();
                        if (!inversionBitTypes.containsKey(state)) {
                            inversionBitTypes.put(state, 1);
                            continue;
                        }
                        inversionBitTypes.put(state, (Integer)inversionBitTypes.get(state) + 1);
                    }
                }
            }
            if (oneBitTypeInversionRequirement && mode == 3 && inversionBitTypes.size() > 1) {
                canInvert = false;
            }
            if (canInvert) {
                Integer max = (Integer)Collections.max(inversionBitTypes.values());
                for (Map.Entry entry : inversionBitTypes.entrySet()) {
                    if (entry.getValue() != max) continue;
                    try {
                        IBitBrush commonBit;
                        invertBit = commonBit = api.createBrushFromState((IBlockState)entry.getKey());
                    }
                    catch (APIExceptions.InvalidBitItem e) {
                        canInvert = false;
                    }
                    break;
                }
            }
            if (!creativeMode && canInvert) {
                IBlockState invertBitState = invertBit.getState();
                bitCountTake = bitCountEmpty - (Integer)inversionBitTypes.get(invertBitState);
                inversionBitTypes.put(invertBitState, Math.max(0, (Integer)inversionBitTypes.get(invertBitState) - bitCountEmpty));
                if (bitCountTake > 0 && ((invertBitStack = invertBit.getItemStack(1)).func_77973_b() == null || BitInventoryHelper.countInventoryBits(api, player, invertBitStack) < bitCountTake)) {
                    canInvert = false;
                }
            }
            int n = increment2 = invertDirection ? -increment : increment;
            if ((mode != 2 || canTranslate) && (mode != 3 || canInvert)) {
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        for (int k = 0; k < 16; ++k) {
                            IBitBrush bit = bitArray[i][j][k];
                            int x = i;
                            int y = j;
                            int z = k;
                            switch (mode) {
                                case 0: {
                                    switch (s) {
                                        case 0: {
                                            x = k;
                                            y = j;
                                            z = 15 - i;
                                            break;
                                        }
                                        case 1: {
                                            x = 15 - k;
                                            y = j;
                                            z = i;
                                            break;
                                        }
                                        case 2: {
                                            x = 15 - j;
                                            y = i;
                                            z = k;
                                            break;
                                        }
                                        case 3: {
                                            x = j;
                                            y = 15 - i;
                                            z = k;
                                            break;
                                        }
                                        case 4: {
                                            x = i;
                                            y = 15 - k;
                                            z = j;
                                            break;
                                        }
                                        case 5: {
                                            x = i;
                                            y = k;
                                            z = 15 - j;
                                        }
                                    }
                                    break;
                                }
                                case 1: {
                                    if (s <= 1) {
                                        y = 15 - j;
                                        break;
                                    }
                                    if (s <= 3) {
                                        z = 15 - k;
                                        break;
                                    }
                                    x = 15 - i;
                                    break;
                                }
                                case 2: {
                                    int i2 = i + side.func_82601_c() * increment2;
                                    int j2 = j + side.func_96559_d() * increment2;
                                    int k2 = k + side.func_82599_e() * increment2;
                                    if (i2 >= 0 && j2 >= 0 && k2 >= 0 && i2 < 16 && j2 < 16 && k2 < 16) {
                                        bit = bitArray[i2][j2][k2];
                                    }
                                    if (!(s == 4 && i < removalLayer + increment || s == 5 && i > removalLayer - increment || s == 0 && j < removalLayer + increment || s == 1 && j > removalLayer - increment || s == 2 && k < removalLayer + increment) && (s != 3 || k <= removalLayer - increment)) break;
                                    bit = null;
                                    break;
                                }
                                case 3: {
                                    bit = bit.isAir() ? invertBit : null;
                                }
                            }
                            try {
                                bitAccess.setBitAt(x, y, z, bit);
                                continue;
                            }
                            catch (APIExceptions.SpaceOccupied e) {
                                if (bit == null || bit.isAir() || !bitAccess.getBitAt(x, y, z).isAir()) continue;
                                return EnumActionResult.FAIL;
                            }
                        }
                    }
                }
                bitAccess.commitChanges(true);
                this.damageTool(stack, player);
                if (!creativeMode && !world.field_72995_K && canInvert) {
                    if (bitCountTake > 0) {
                        BitInventoryHelper.removeOrAddInventoryBits(api, player, invertBitStack, bitCountTake, false);
                    }
                    if (mode == 3) {
                        Cube cube = new Cube();
                        float f = 0.5f;
                        cube.init((float)pos.func_177958_n() + f, (float)pos.func_177956_o() + f, (float)pos.func_177952_p() + f, f, 0, false, 0.0f, false);
                        BitInventoryHelper.giveOrDropStacks(player, world, pos, cube, api, inversionBitTypes);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        int mode = this.getMode(stack);
        String text = MODE_TEXT[mode].toLowerCase();
        if (GuiScreen.func_146271_m()) {
            String shiftText = ItemBitWrench.getColoredKeyBindText(KeyBindingsExtraBitManipulation.SHIFT);
            tooltip.add("Right click blocks to " + text + (mode == 0 ? " CW." : (mode == 1 ? " front-to-back." : (mode == 2 ? " front-to-back." : " their bits."))));
            if (mode != 3) {
                tooltip.add(shiftText + " right click blocks to " + text + (mode == 0 ? " CCW." : (mode == 1 ? " left-to-right." : " towards you.")));
            }
            tooltip.add(shiftText + " mouse wheel to cycle modes.");
            ItemBitWrench.addKeybindReminders(tooltip, KeyBindingsExtraBitManipulation.SHIFT);
        } else {
            ItemBitWrench.addKeyInformation(tooltip, false);
        }
    }

    public String func_77653_i(ItemStack stack) {
        TextComponentTranslation textTrans = new TextComponentTranslation(this.func_77657_g(stack) + ".name", new Object[0]);
        return textTrans.func_150260_c() + " - " + MODE_TITLES[this.getMode(stack)];
    }

    private int getMode(ItemStack stack) {
        return ItemStackHelper.getNBTOrNew(stack).func_74762_e("wrenchMode");
    }
}

