/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.init;

import com.phylogeny.extrabitmanipulation.armor.ChiseledArmorStackHandeler;
import com.phylogeny.extrabitmanipulation.armor.model.cnpc.CustomNPCsModels;
import com.phylogeny.extrabitmanipulation.armor.model.mpm.MorePlayerModelsModels;
import com.phylogeny.extrabitmanipulation.armor.model.vanilla.ModelChiseledArmor;
import com.phylogeny.extrabitmanipulation.armor.model.vanilla.ModelChiseledArmorLeggings;
import com.phylogeny.extrabitmanipulation.block.BlockExtraBitManipulationBase;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemExtraBitManipulationBase;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.reference.CustomNPCsReferences;
import com.phylogeny.extrabitmanipulation.reference.MorePlayerModelsReference;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelRegistration {
    private static final String ARMOR_TEXTURE_PATH_DIANOND = "extrabitmanipulation:textures/armor/chiseled_armor_diamond.png";
    private static final String ARMOR_TEXTURE_PATH_IRON = "extrabitmanipulation:textures/armor/chiseled_armor_iron.png";
    private static ModelBiped armorModelEmpty;
    private static ModelBiped armorModel;
    private static ModelBiped armorModelLeggings;
    private static ModelBiped armorModelMPM;
    private static ModelBiped armorModelLeggingsMPM;
    private static ModelBiped armorModelCNPC;
    private static ModelBiped armorModelLeggingsCNPC;

    public static void registerItemModels() {
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledHelmetDiamond);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledChestplateDiamond);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledLeggingsDiamond);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledBootsDiamond);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledHelmetIron);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledChestplateIron);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledLeggingsIron);
        ModelRegistration.registerChiseledArmorItemModel(ItemsExtraBitManipulation.chiseledBootsIron);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.diamondNugget);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.bitWrench);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingLoop);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSquare);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeCurved);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeSquared);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.modelingTool);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.modelingToolHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.bitWrenchHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingLoopHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSquareHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeCurvedHead);
        ModelRegistration.registerItemModel(ItemsExtraBitManipulation.sculptingSpadeSquaredHead);
        ModelRegistration.registerItemBlockModel(BlocksExtraBitManipulation.bodyPartTemplate);
        armorModel = new ModelChiseledArmor();
        armorModelLeggings = new ModelChiseledArmorLeggings();
        armorModelEmpty = new ModelBiped();
        if (MorePlayerModelsReference.isLoaded) {
            MorePlayerModelsModels.initModels();
            armorModelMPM = MorePlayerModelsModels.ARMOR_MODEL_MPM;
            armorModelLeggingsMPM = MorePlayerModelsModels.ARMOR_MODEL_LEGGINGS_MPM;
        }
        if (CustomNPCsReferences.isLoaded) {
            CustomNPCsModels.initModels();
            armorModelCNPC = CustomNPCsModels.ARMOR_MODEL_CNPC;
            armorModelLeggingsCNPC = CustomNPCsModels.ARMOR_MODEL_LEGGINGS_CNPC;
        }
        ModelRegistration.armorModelEmpty.field_78116_c.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_78115_e.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178723_h.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178724_i.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178721_j.field_78804_l.clear();
        ModelRegistration.armorModelEmpty.field_178722_k.field_78804_l.clear();
        ModelRegistration.registerIsolatedModels(ItemsExtraBitManipulation.chiseledHelmetDiamond, ItemChiseledArmor.ArmorMovingPart.initAndGetIconModelLocations());
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledHelmetDiamond);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledChestplateDiamond);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledLeggingsDiamond);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledBootsDiamond);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledHelmetIron);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledChestplateIron);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledLeggingsIron);
        ModelRegistration.registerBakedItemModel(event, ItemsExtraBitManipulation.chiseledBootsIron);
    }

    private static void registerBakedItemModel(ModelBakeEvent event, Item item) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(item.getRegistryName(), "inventory"), (Object)new ChiseledArmorStackHandeler.ChiseledArmorBakedModel());
    }

    private static void registerItemBlockModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ModelRegistration.registerItemModel(item, ((BlockExtraBitManipulationBase)block).getName());
        }
    }

    private static void registerItemModel(Item item) {
        ModelRegistration.registerItemModel(item, ((ItemExtraBitManipulationBase)item).getName());
    }

    private static void registerChiseledArmorItemModel(Item item) {
        ItemChiseledArmor armorPiece = (ItemChiseledArmor)item;
        ResourceLocation name = armorPiece.getRegistryName();
        if (name == null) {
            return;
        }
        ModelRegistration.registerItemModel((Item)armorPiece, name.func_110623_a());
        ModelRegistration.registerIsolatedModels((Item)armorPiece, armorPiece.initItemModelLocation());
        armorPiece.field_77881_a.initIconStack((Item)armorPiece);
    }

    private static void registerItemModel(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("extrabitmanipulation", name), "inventory"));
    }

    private static void registerIsolatedModels(Item item, ResourceLocation ... resourceLocations) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])resourceLocations);
    }

    public static ModelBiped getArmorModel(ItemStack stack, EntityEquipmentSlot slot, EntityLivingBase entity) {
        if (ModelRegistration.shouldRenderEmptymodel(stack)) {
            return armorModelEmpty;
        }
        if (CustomNPCsReferences.isLoaded && CustomNPCsModels.isCustomNPC(entity)) {
            return slot == EntityEquipmentSlot.LEGS ? armorModelLeggingsCNPC : armorModelCNPC;
        }
        return !MorePlayerModelsReference.isLoaded || !(entity instanceof EntityPlayer) ? (slot == EntityEquipmentSlot.LEGS ? armorModelLeggings : armorModel) : (slot == EntityEquipmentSlot.LEGS ? armorModelLeggingsMPM : armorModelMPM);
    }

    public static String getArmorTexture(ItemStack stack, ItemArmor.ArmorMaterial material) {
        return ModelRegistration.shouldRenderEmptymodel(stack) ? null : (material == ItemArmor.ArmorMaterial.DIAMOND ? ARMOR_TEXTURE_PATH_DIANOND : ARMOR_TEXTURE_PATH_IRON);
    }

    private static boolean shouldRenderEmptymodel(ItemStack stack) {
        return Configs.armorModelRenderMode == ArmorModelRenderMode.NEVER || Configs.armorModelRenderMode == ArmorModelRenderMode.IF_EMPTY && ItemStackHelper.isChiseledArmorNotEmpty(stack);
    }

    public static enum ArmorModelRenderMode {
        IF_EMPTY,
        NEVER,
        ALWAYS;

    }
}

