/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor.capability;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.armor.ModelPartConcealer;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketSyncArmorSlot;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class ChiseledArmorSlotsHandler
extends ItemStackHandler
implements ICapabilityProvider,
IChiseledArmorSlotsHandler {
    public static final int COUNT_TYPES = 4;
    public static final int COUNT_SETS = 4;
    public static final int COUNT_SLOTS_TOTAL = 16;
    private boolean[] syncedSlots = new boolean[16];
    private boolean[] hasArmorSet = new boolean[4];
    private boolean[] hasArmorType = new boolean[4];
    private boolean hasArmor;
    private ModelPartConcealer modelPartConcealer;
    @CapabilityInject(value=IChiseledArmorSlotsHandler.class)
    public static final Capability<IChiseledArmorSlotsHandler> ARMOR_SLOTS_CAP = null;

    public ChiseledArmorSlotsHandler() {
        super(16);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return ARMOR_SLOTS_CAP != null && capability == ARMOR_SLOTS_CAP;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == ARMOR_SLOTS_CAP ? ARMOR_SLOTS_CAP.cast((Object)this) : null);
    }

    public static IChiseledArmorSlotsHandler getCapability(EntityPlayer player) {
        return (IChiseledArmorSlotsHandler)player.getCapability(ARMOR_SLOTS_CAP, null);
    }

    @Override
    public void syncAllSlots(EntityPlayer player) {
        HashSet<EntityPlayer> players = null;
        for (int i = 0; i < 16; ++i) {
            if (this.syncedSlots[i]) continue;
            if (players == null) {
                players = new HashSet<EntityPlayer>();
                players.addAll(((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player));
                players.add(player);
            }
            for (EntityPlayer player2 : players) {
                ExtraBitManipulation.packetNetwork.sendTo((IMessage)new PacketSyncArmorSlot(player.func_110124_au(), this.getStackInSlot(i), i), (EntityPlayerMP)player2);
            }
            this.syncedSlots[i] = true;
        }
    }

    @Override
    public void markAllSlotsDirty() {
        this.syncedSlots = new boolean[16];
    }

    @Override
    public void markSlotDirty(int index) {
        this.syncedSlots[index] = false;
    }

    @Override
    @Nullable
    public ModelPartConcealer getAndApplyModelPartConcealer(ModelBiped model) {
        return this.modelPartConcealer == null ? null : this.modelPartConcealer.copy().applyToModel(model);
    }

    @Override
    public void onContentsChanged(int slot) {
        int start;
        this.markSlotDirty(slot);
        int index = slot / 4;
        this.hasArmorSet[index] = false;
        for (int i = start = index * 4; i < start + 4; ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            this.hasArmorSet[index] = true;
            break;
        }
        this.hasArmor = false;
        for (boolean setHasArmor : this.hasArmorSet) {
            if (!setHasArmor) continue;
            this.hasArmor = true;
            break;
        }
        boolean bl = !((ItemStack)this.stacks.get(index = slot % 4)).func_190926_b();
        this.hasArmorType[index] = bl;
        ModelPartConcealer modelPartConcealer = new ModelPartConcealer();
        for (int i = 0; i < 16 && !modelPartConcealer.isFull(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) continue;
            modelPartConcealer.merge(ModelPartConcealer.loadFromNBT(nbt));
        }
        this.modelPartConcealer = !modelPartConcealer.isEmpty() ? modelPartConcealer : null;
    }

    public static int findNextArmorSetIndex(int startIndex) {
        int indexNext = startIndex;
        do {
            if (!ChiseledArmorSlotsHandler.setHasArmor(indexNext = (indexNext + 1) % 5)) continue;
            return indexNext;
        } while (indexNext != startIndex);
        return -1;
    }

    public static boolean setHasArmor(int index) {
        for (ItemChiseledArmor.ArmorType armorType : ItemChiseledArmor.ArmorType.values()) {
            if (!ItemStackHelper.isChiseledArmorStack(ItemStackHelper.getChiseledArmorStack(ClientHelper.getPlayer(), armorType, index))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasArmor() {
        return this.hasArmor;
    }

    @Override
    public boolean hasArmorSet(int indexSet) {
        return this.hasArmorSet[indexSet];
    }

    @Override
    public boolean hasArmorType(int indexType) {
        return this.hasArmorType[indexType];
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void setSize(int size) {
        super.setSize(16);
    }

    public static boolean isItemValid(int slot, ItemStack stack) {
        return ItemStackHelper.isChiseledArmorStack(stack) && ((ItemChiseledArmor)stack.func_77973_b()).field_77881_a.ordinal() == slot % 4 && ItemStackHelper.isChiseledArmorNotEmpty(stack);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || ChiseledArmorSlotsHandler.isItemValid(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return ChiseledArmorSlotsHandler.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
    }
}

