/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.google.common.primitives.Bytes;
import com.phylogeny.extrabitmanipulation.armor.model.cnpc.CustomNPCsModels;
import com.phylogeny.extrabitmanipulation.armor.model.mpm.MorePlayerModelsModels;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.CustomNPCsReferences;
import com.phylogeny.extrabitmanipulation.reference.MorePlayerModelsReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.nbt.NBTTagCompound;

public class ModelPartConcealer {
    private Set<ItemChiseledArmor.ModelMovingPart> concealedParts = new HashSet<ItemChiseledArmor.ModelMovingPart>();
    private Set<ItemChiseledArmor.ModelMovingPart> concealedPartOverlays = new HashSet<ItemChiseledArmor.ModelMovingPart>();
    private Set<ItemChiseledArmor.ModelMovingPart> concealedPartsCombined = new HashSet<ItemChiseledArmor.ModelMovingPart>();
    private Map<ItemChiseledArmor.ModelMovingPart, ModelRenderer> concealedPartRenderers = new HashMap<ItemChiseledArmor.ModelMovingPart, ModelRenderer>();

    public ModelPartConcealer() {
    }

    private ModelPartConcealer(byte[] concealedParts, byte[] concealedPartOverlays) {
        this.concealedParts = this.indexArrayToPartSet(concealedParts);
        this.concealedPartsCombined.addAll(this.concealedParts);
        this.concealedPartOverlays = this.indexArrayToPartSet(concealedPartOverlays);
        this.concealedPartsCombined.addAll(this.concealedPartOverlays);
    }

    private Set<ItemChiseledArmor.ModelMovingPart> indexArrayToPartSet(byte[] parts) {
        return IntStream.range(0, parts.length).boxed().map(index -> ItemChiseledArmor.ModelMovingPart.values()[parts[index]]).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.concealedPartsCombined.isEmpty();
    }

    public boolean isFull() {
        return this.concealedParts.size() == ItemChiseledArmor.ModelMovingPart.values().length && this.concealedPartOverlays.size() == ItemChiseledArmor.ModelMovingPart.values().length;
    }

    private byte[] partsToByteArray(Set<ItemChiseledArmor.ModelMovingPart> parts) {
        return Bytes.toArray((Collection)parts.stream().map(part -> (byte)part.ordinal()).collect(Collectors.toSet()));
    }

    public void saveToNBT(NBTTagCompound nbt) {
        this.savePartsToNBT(nbt, this.concealedParts, "concealedParts");
        this.savePartsToNBT(nbt, this.concealedPartOverlays, "concealedOverlays");
    }

    private void savePartsToNBT(NBTTagCompound nbt, Set<ItemChiseledArmor.ModelMovingPart> parts, String key) {
        byte[] partsArray = this.partsToByteArray(parts);
        if (partsArray.length > 0) {
            nbt.func_74773_a(key, partsArray);
        } else {
            nbt.func_82580_o(key);
        }
    }

    @Nullable
    public static ModelPartConcealer loadFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("concealedParts") && !nbt.func_74764_b("concealedOverlays")) {
            return null;
        }
        byte[] concealedParts = nbt.func_74770_j("concealedParts");
        byte[] concealedPartOverlays = nbt.func_74770_j("concealedOverlays");
        return concealedParts.length > 0 || concealedPartOverlays.length > 0 ? new ModelPartConcealer(concealedParts, concealedPartOverlays).copy() : null;
    }

    public void merge(@Nullable ModelPartConcealer modelPartConcealer) {
        if (modelPartConcealer != null) {
            this.concealedParts.addAll(modelPartConcealer.concealedParts);
            this.concealedPartOverlays.addAll(modelPartConcealer.concealedPartOverlays);
            this.concealedPartsCombined.addAll(modelPartConcealer.concealedPartsCombined);
        }
    }

    public ModelPartConcealer copy() {
        return new ModelPartConcealer(this.partsToByteArray(this.concealedParts), this.partsToByteArray(this.concealedPartOverlays));
    }

    private Set<ItemChiseledArmor.ModelMovingPart> getParts(boolean isOverlay) {
        return isOverlay ? this.concealedPartOverlays : this.concealedParts;
    }

    public boolean contains(ItemChiseledArmor.ModelMovingPart part, boolean isOverlay) {
        return this.getParts(isOverlay).contains((Object)part);
    }

    public void addOrRemove(int partIndex, boolean isOverlay, boolean remove) {
        ItemChiseledArmor.ModelMovingPart part = ItemChiseledArmor.ModelMovingPart.values()[partIndex];
        Set<ItemChiseledArmor.ModelMovingPart> parts = this.getParts(isOverlay);
        if (remove) {
            parts.remove((Object)part);
        } else {
            parts.add(part);
        }
    }

    public void restoreModelPartVisiblity(ModelBiped model) {
        this.concealedPartRenderers.keySet().forEach(part -> {
            ModelRenderer renderer = this.concealedPartRenderers.get(part);
            switch (part) {
                case HEAD: {
                    model.field_78116_c = renderer;
                    break;
                }
                case BODY: {
                    model.field_78115_e = renderer;
                    break;
                }
                case ARM_RIGHT: {
                    model.field_178723_h = renderer;
                    break;
                }
                case ARM_LEFT: {
                    model.field_178724_i = renderer;
                    break;
                }
                case LEG_RIGHT: {
                    model.field_178721_j = renderer;
                    break;
                }
                case LEG_LEFT: {
                    model.field_178722_k = renderer;
                }
            }
        });
    }

    public ModelPartConcealer applyToModel(ModelBiped model) {
        this.concealedParts.forEach(part -> {
            switch (part) {
                case HEAD: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_78116_c);
                    model.field_78116_c = this.getEmptyModelRenderer(model, model.field_78116_c, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                    break;
                }
                case BODY: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_78115_e);
                    model.field_78115_e = this.getEmptyModelRenderer(model, model.field_78115_e, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                    break;
                }
                case ARM_RIGHT: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_178723_h);
                    model.field_178723_h = this.getEmptyModelRenderer(model, model.field_178723_h, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                    break;
                }
                case ARM_LEFT: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_178724_i);
                    model.field_178724_i = this.getEmptyModelRenderer(model, model.field_178724_i, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                    break;
                }
                case LEG_RIGHT: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_178721_j);
                    model.field_178721_j = this.getEmptyModelRenderer(model, model.field_178721_j, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                    break;
                }
                case LEG_LEFT: {
                    this.concealedPartRenderers.put((ItemChiseledArmor.ModelMovingPart)((Object)part), model.field_178722_k);
                    model.field_178722_k = this.getEmptyModelRenderer(model, model.field_178722_k, (ItemChiseledArmor.ModelMovingPart)((Object)part));
                }
            }
        });
        if (!(model instanceof ModelPlayer)) {
            return this;
        }
        ModelPlayer modelPlayer = (ModelPlayer)model;
        this.concealedPartOverlays.forEach(part -> {
            switch (part) {
                case HEAD: {
                    modelPlayer.field_178720_f.field_78806_j = false;
                    break;
                }
                case BODY: {
                    modelPlayer.field_178730_v.field_78806_j = false;
                    break;
                }
                case ARM_RIGHT: {
                    modelPlayer.field_178732_b.field_78806_j = false;
                    break;
                }
                case ARM_LEFT: {
                    modelPlayer.field_178734_a.field_78806_j = false;
                    break;
                }
                case LEG_RIGHT: {
                    modelPlayer.field_178731_d.field_78806_j = false;
                    break;
                }
                case LEG_LEFT: {
                    modelPlayer.field_178733_c.field_78806_j = false;
                }
            }
        });
        return this;
    }

    private ModelRenderer getEmptyModelRenderer(ModelBiped model, ModelRenderer renderer, ItemChiseledArmor.ModelMovingPart part) {
        if (MorePlayerModelsReference.isLoaded && MorePlayerModelsModels.isModelRendererMPM(renderer)) {
            ModelRenderer modelRenderer = MorePlayerModelsModels.getEmptyModelRenderer(model, renderer, part);
            if (part.ordinal() > 3) {
                modelRenderer.field_78800_c = (float)((double)modelRenderer.field_78800_c + (part == ItemChiseledArmor.ModelMovingPart.LEG_LEFT ? 1.9 : -1.9));
            }
            return modelRenderer;
        }
        if (CustomNPCsReferences.isLoaded && CustomNPCsModels.isModelRendererCNPC(renderer)) {
            ModelRenderer modelRenderer = CustomNPCsModels.getEmptyModelRenderer(model, renderer, part);
            if (part.ordinal() > 3) {
                modelRenderer.field_78800_c = (float)((double)modelRenderer.field_78800_c + (part == ItemChiseledArmor.ModelMovingPart.LEG_LEFT ? 1.9 : -1.9));
            }
            return modelRenderer;
        }
        return new ModelRendererEmpty(renderer);
    }

    public static class ModelRendererEmpty
    extends ModelRenderer {
        private static final ModelBase MODEL_EMPTY = new ModelBase(){};

        public ModelRendererEmpty(ModelRenderer renderer) {
            super(MODEL_EMPTY);
            ModelBiped.func_178685_a((ModelRenderer)renderer, (ModelRenderer)this);
        }

        public void func_78785_a(float scale) {
        }
    }
}

