/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.init;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class IgnoreNBTIngredient
extends Ingredient {
    private final ItemStack[] matchingStacks;
    private IntList matchingStacksPacked;

    protected IgnoreNBTIngredient(ItemStack ... stacks) {
        super(0);
        this.matchingStacks = stacks;
    }

    public ItemStack[] func_193365_a() {
        return this.matchingStacks;
    }

    public boolean apply(@Nullable ItemStack stackToCheck) {
        if (stackToCheck == null) {
            return false;
        }
        for (ItemStack stack : this.matchingStacks) {
            int metadata;
            if (stack.func_77973_b() != stackToCheck.func_77973_b() || (metadata = stack.func_77960_j()) != Short.MAX_VALUE && !ItemStack.func_185132_d((ItemStack)stackToCheck, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public IntList func_194139_b() {
        if (this.matchingStacksPacked == null) {
            this.matchingStacksPacked = new IntArrayList(this.matchingStacks.length);
            for (ItemStack itemstack : this.matchingStacks) {
                this.matchingStacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.matchingStacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    protected void invalidate() {
        this.matchingStacksPacked = null;
    }

    public static Ingredient fromStacks(ItemStack ... stacks) {
        if (stacks.length > 0) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.func_190926_b()) continue;
                return new IgnoreNBTIngredient(stacks);
            }
        }
        return field_193370_a;
    }

    public static class Factory
    implements IIngredientFactory {
        public Ingredient parse(JsonContext context, JsonObject json) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (JsonContext)context);
            return IgnoreNBTIngredient.fromStacks(stack);
        }
    }
}

