/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SyncValueEnergyStorage;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxStorage;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.tabs.GuiTabIndexStorage;
import sonar.flux.common.tileentity.TileFluxConnector;
import sonar.flux.connection.transfer.StorageTransfer;
import sonar.flux.connection.transfer.handlers.SingleTransferHandler;

public abstract class TileStorage
extends TileFluxConnector
implements IFluxStorage {
    public final SingleTransferHandler handler = new SingleTransferHandler(this, new StorageTransfer(this));
    public final SyncValueEnergyStorage storage = new SyncValueEnergyStorage((IValueWatcher)this.value_watcher);
    public int maxTransfer;
    public long lastStorageUpdate;
    public boolean updateStorage;
    public int targetEnergy;

    public TileStorage(int capacity, int transfer) {
        super(IFlux.ConnectionType.STORAGE);
        this.maxTransfer = transfer;
        this.storage.setCapacity(capacity);
        this.storage.setMaxTransfer(transfer);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateStorage && this.lastStorageUpdate == 0L) {
                this.lastStorageUpdate = this.func_145831_w().func_72820_D();
            } else if (this.updateStorage && this.func_145831_w().func_72820_D() > this.lastStorageUpdate + 20L) {
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)10);
                this.lastStorageUpdate = this.func_145831_w().func_72820_D();
                this.updateStorage = false;
            }
        } else if (this.updateStorage && this.storage.getEnergyStored() != this.targetEnergy) {
            int inc = this.storage.getMaxEnergyStored() / 50;
            int dif = Math.abs(this.storage.getEnergyStored() - this.targetEnergy);
            if (dif < inc * 2) {
                inc /= 4;
            }
            if (this.storage.getEnergyStored() < this.targetEnergy) {
                this.storage.setEnergyStored(Math.min(this.storage.getEnergyStored() + inc, this.targetEnergy));
            } else {
                this.storage.setEnergyStored(Math.max(this.storage.getEnergyStored() - inc, this.targetEnergy));
            }
        } else {
            this.updateStorage = false;
        }
    }

    @Override
    public EnumFacing[] getValidFaces() {
        return new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    }

    @Override
    public void onInternalValueChanged(ISonarValue value) {
        super.onInternalValueChanged(value);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.storage == value) {
            this.updateStorage = true;
        }
    }

    @Override
    public long getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public long getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getCurrentLimit() {
        return Math.min(super.getCurrentLimit(), (long)this.storage.getMaxExtract());
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP, NBTHelper.SyncType.SPECIAL})) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP, NBTHelper.SyncType.SPECIAL})) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
        return nbt;
    }

    public ItemStack writeStorageToDisplayStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("sonar_drop");
        this.writeData(tag, NBTHelper.SyncType.DROP);
        return stack;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 10: {
                buf.writeInt(this.storage.getEnergyStored());
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 10: {
                this.targetEnergy = buf.readInt();
                this.updateStorage = this.targetEnergy != this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public Object getIndexScreen(List<EnumGuiTab> tabs) {
        return new GuiTabIndexStorage(tabs);
    }

    public static class Gargantuan
    extends TileStorage {
        public Gargantuan() {
            super(FluxConfig.gargantuanCapacity, FluxConfig.gargantuanTransfer);
            this.customName.setValueInternal((Object)"Gargantuan Storage");
        }

        @Override
        public ItemStack getDisplayStack() {
            return this.writeStorageToDisplayStack(new ItemStack(FluxNetworks.massiveFluxStorage, 1));
        }
    }

    public static class Herculean
    extends TileStorage {
        public Herculean() {
            super(FluxConfig.herculeanCapacity, FluxConfig.herculeanTransfer);
            this.customName.setValueInternal((Object)"Herculean Storage");
        }

        @Override
        public ItemStack getDisplayStack() {
            return this.writeStorageToDisplayStack(new ItemStack(FluxNetworks.largeFluxStorage, 1));
        }
    }

    public static class Basic
    extends TileStorage {
        public Basic() {
            super(FluxConfig.basicCapacity, FluxConfig.basicTransfer);
            this.customName.setValueInternal((Object)"Basic Storage");
        }

        @Override
        public ItemStack getDisplayStack() {
            return this.writeStorageToDisplayStack(new ItemStack(FluxNetworks.fluxStorage, 1));
        }
    }
}

