/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.ClientTransferHandler;
import sonar.flux.api.energy.internal.IFluxTransfer;
import sonar.flux.connection.transfer.BaseFluxTransfer;
import sonar.flux.connection.transfer.ISidedTransfer;
import sonar.flux.connection.transfer.PhantomTransfer;
import sonar.flux.network.FluxNetworkData;

public class ClientTransfer
implements INBTSyncable,
IFluxTransfer {
    public EnergyType energyType;
    public EnumFacing direction;
    public boolean isPhantomPower;
    public long added;
    public long removed;
    public ItemStack stack;
    public ClientTransferHandler handler;

    public ClientTransfer(ClientTransferHandler handler) {
        this.handler = handler;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.energyType = EnergyType.readFromNBT((NBTTagCompound)nbt, (String)FluxNetworkData.ENERGY_TYPE);
        byte direction_byte = nbt.func_74771_c("d");
        this.direction = direction_byte == -1 ? null : EnumFacing.field_82609_l[direction_byte];
        this.isPhantomPower = nbt.func_74767_n("p");
        this.added = nbt.func_74763_f("a");
        this.removed = nbt.func_74763_f("r");
        this.stack = new ItemStack(nbt);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        EnergyType.writeToNBT((EnergyType)this.energyType, (NBTTagCompound)nbt, (String)FluxNetworkData.ENERGY_TYPE);
        nbt.func_74774_a("d", this.direction == null ? (byte)-1 : (byte)this.direction.ordinal());
        if (this.isPhantomPower) {
            nbt.func_74757_a("p", this.isPhantomPower);
        }
        if (this.added != 0L) {
            nbt.func_74772_a("a", this.added);
        }
        if (this.removed != 0L) {
            nbt.func_74772_a("r", this.removed);
        }
        this.stack.func_77955_b(nbt);
        return nbt;
    }

    public static ClientTransfer getInstanceFromHandler(ClientTransferHandler handler, IFluxTransfer transfer) {
        ClientTransfer clientTransfer = new ClientTransfer(handler);
        clientTransfer.energyType = transfer.getEnergyType();
        if (transfer instanceof BaseFluxTransfer) {
            BaseFluxTransfer baseTransfer = (BaseFluxTransfer)transfer;
            clientTransfer.added = baseTransfer.added;
            clientTransfer.removed = baseTransfer.removed;
        }
        if (transfer instanceof ISidedTransfer) {
            ISidedTransfer sided = (ISidedTransfer)transfer;
            clientTransfer.direction = sided.getDirection();
        }
        clientTransfer.isPhantomPower = transfer instanceof PhantomTransfer;
        clientTransfer.stack = transfer.getDisplayStack();
        return clientTransfer;
    }

    @Override
    public void onStartServerTick() {
    }

    @Override
    public void onEndWorldTick() {
    }

    @Override
    public void addedToNetwork(long add, EnergyType energyType) {
    }

    @Override
    public void removedFromNetwork(long remove, EnergyType energyType) {
    }

    @Override
    public EnergyType getEnergyType() {
        return this.energyType;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stack;
    }
}

