/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.util;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.client.util.BlockArrayRenderHelper;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicMachineRenderContext {
    private final DynamicMachine machine;
    private final BlockArrayRenderHelper render;
    private final Vec3i moveOffset;
    private boolean render3D = true;
    private int renderSlice = 0;
    private float scale = 1.0f;
    private long shiftSnap = -1L;

    private DynamicMachineRenderContext(DynamicMachine machine) {
        this.machine = machine;
        TaggedPositionBlockArray pattern = machine.getPattern();
        Vec3i min = pattern.getMin();
        Vec3i max = pattern.getMax();
        this.moveOffset = new Vec3i((min.func_177958_n() + (max.func_177958_n() - min.func_177958_n()) / 2) * -1, -min.func_177956_o(), (min.func_177952_p() + (max.func_177952_p() - min.func_177952_p()) / 2) * -1);
        BlockArray copy = new BlockArray(pattern, this.moveOffset);
        copy.addBlock(new BlockPos(this.moveOffset), new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{new BlockArray.IBlockStateDescriptor(BlocksMM.blockController.func_176223_P())})));
        this.render = new BlockArrayRenderHelper(copy);
    }

    BlockArrayRenderHelper getRender() {
        return this.render;
    }

    public Vec3i getMoveOffset() {
        return this.moveOffset;
    }

    public long getShiftSnap() {
        return this.shiftSnap;
    }

    public void snapSamples() {
        this.shiftSnap = ClientScheduler.getClientTick();
    }

    public void releaseSamples() {
        this.shiftSnap = -1L;
    }

    public void resetRender() {
        this.setTo2D();
        this.setTo3D();
    }

    public void setTo2D() {
        if (!this.render3D) {
            return;
        }
        this.render3D = false;
        this.renderSlice = this.render.getBlocks().getMin().func_177956_o();
        this.render.resetRotation2D();
        this.scale = 1.0f;
    }

    public void setTo3D() {
        if (this.render3D) {
            return;
        }
        this.render3D = true;
        this.renderSlice = 0;
        this.render.resetRotation();
        this.scale = 1.0f;
    }

    public float getScale() {
        return this.scale;
    }

    public Vec3d getCurrentMachineTranslate() {
        if (this.render3D) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        return this.render.getCurrentTranslation();
    }

    public Vec2f getCurrentRenderOffset(float x, float z) {
        Minecraft mc = Minecraft.func_71410_x();
        double sc = new ScaledResolution(mc).func_78325_e();
        double oX = (double)x + 16.0 / sc;
        double oZ = (double)z + 16.0 / sc;
        Vec3d tr = this.getCurrentMachineTranslate();
        return new Vec2f((float)(oX + tr.field_72450_a), (float)(oZ + tr.field_72449_c));
    }

    public void zoomOut() {
        this.scale *= 0.85f;
    }

    public void zoomIn() {
        this.scale *= 1.15f;
    }

    public boolean doesRenderIn3D() {
        return this.render3D;
    }

    public int getRenderSlice() {
        return this.renderSlice;
    }

    public boolean hasSliceDown() {
        return this.render.getBlocks().getMin().func_177956_o() - this.moveOffset.func_177956_o() < this.renderSlice - 1;
    }

    public boolean hasSliceUp() {
        return this.render.getBlocks().getMax().func_177956_o() + this.moveOffset.func_177956_o() > this.renderSlice + 1;
    }

    public void sliceUp() {
        if (this.hasSliceUp()) {
            ++this.renderSlice;
        }
    }

    public void sliceDown() {
        if (this.hasSliceDown()) {
            --this.renderSlice;
        }
    }

    public DynamicMachine getDisplayedMachine() {
        return this.machine;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getDescriptiveStacks() {
        return this.getDisplayedMachine().getPattern().getAsDescriptiveStacks(this.shiftSnap == -1L ? Optional.empty() : Optional.of(this.shiftSnap));
    }

    public static DynamicMachineRenderContext createContext(DynamicMachine machine) {
        return new DynamicMachineRenderContext(machine);
    }

    public void renderAt(int x, int z) {
        this.renderAt(x, z, 1.0f);
    }

    public void renderAt(int x, int z, float partialTicks) {
        this.render.sampleSnap = this.shiftSnap;
        if (this.render3D) {
            this.render.render3DGUI(x, z, this.scale, partialTicks);
        } else {
            this.render.render3DGUI(x, z, this.scale, partialTicks, Optional.of(this.renderSlice + this.moveOffset.func_177956_o()));
        }
    }

    public void rotateRender(double x, double y, double z) {
        this.render.rotate(x, y, z);
    }

    public void moveRender(double x, double y, double z) {
        this.render.translate(x, y, z);
    }
}

