/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.IWireInsulated;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.simplelogic.wires.LogicWireUtils;
import pl.asie.simplelogic.wires.logic.PartWireNormal;
import pl.asie.simplelogic.wires.logic.PropagationQueue;

public class PartWireInsulated
extends PartWireNormal
implements IWireInsulated {
    public PartWireInsulated(@Nonnull IWireContainer container, @Nonnull WireProvider factory, @Nonnull WireFace location) {
        super(container, factory, location);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        int c = 0xFF000000 | EnumDyeColor.func_176764_b((int)this.getColor()).func_193350_e();
        return c & 0xFF00FF00 | c >> 16 & 0xFF | c << 16 & 0xFF0000;
    }

    @Override
    protected int getWireRedstoneLevel(IBlockAccess world, BlockPos pos, WireFace location) {
        return LogicWireUtils.getInsulatedWireLevel(world, pos, location, this.getColor());
    }

    @Override
    protected void onSignalChanged(int color, boolean clearMode) {
        if (!(this.getContainer().world() == null || this.getContainer().pos() == null || this.getContainer().world().field_72995_K || color != this.getColor() && color != -1)) {
            PropagationQueue queue = new PropagationQueue(clearMode);
            queue.add(this, this.getColor());
            queue.propagate();
        }
    }

    public int getWireColor() {
        return this.getColor();
    }

    @Override
    public String getDisplayName() {
        return String.format(I18n.func_74838_a((String)("tile.simplelogic.wire.insulated" + (this.getLocation() == WireFace.CENTER ? ".freestanding.name" : ".name"))), I18n.func_74838_a((String)ColorUtils.getLangEntry((String)"charset.color.", (EnumDyeColor)EnumDyeColor.func_176764_b((int)this.getWireColor()))));
    }
}

