/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.simplelogic.wires.LogicWireUtils;
import pl.asie.simplelogic.wires.logic.PartWireBundled;
import pl.asie.simplelogic.wires.logic.PartWireInsulated;
import pl.asie.simplelogic.wires.logic.PartWireNormal;
import pl.asie.simplelogic.wires.logic.PartWireSignalBase;

public class LogicWireProvider
extends WireProvider {
    public final WireType type;
    public final int color;

    public LogicWireProvider(WireType type, int color) {
        this.type = type;
        this.color = color;
    }

    public boolean canProvidePower() {
        return this.type != WireType.BUNDLED;
    }

    public Wire create(IWireContainer container, WireFace location) {
        PartWireSignalBase wire = null;
        switch (this.type) {
            case NORMAL: {
                wire = new PartWireNormal(container, this, location);
                break;
            }
            case INSULATED: {
                wire = new PartWireInsulated(container, this, location);
                wire.setColor(this.color);
                break;
            }
            case BUNDLED: {
                wire = new PartWireBundled(container, this, location);
                if (this.color < 0) break;
                wire.setColor(this.color);
            }
        }
        return wire;
    }

    public boolean canPlace(IBlockAccess access, BlockPos pos, WireFace face) {
        return face == WireFace.CENTER || LogicWireUtils.canPlaceWire(access, pos.func_177972_a(face.facing), face.facing != null ? face.facing.func_176734_d() : null);
    }

    public float getWidth() {
        return (float)LogicWireUtils.width(this.type) / 16.0f;
    }

    public float getHeight() {
        return (float)LogicWireUtils.height(this.type) / 16.0f;
    }

    public ResourceLocation getTexturePrefix() {
        return new ResourceLocation("simplelogic:blocks/wire/wire_" + this.type.name().toLowerCase());
    }
}

