/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.tesslocator.TesslocatorConfig;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.BasicTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class BasicItemTesslocatorPart
extends BasicTesslocatorPart
implements IItemHandlerModifiable {
    private final BasicItemTesslocatorPart[] temp = new BasicItemTesslocatorPart[5];
    public ItemStack filter = ItemStack.field_190927_a;
    public int boost = 0;
    public final ItemStack[] buffer = new ItemStack[8];
    public int currentSlot = 0;
    public int cooldown = 0;
    public int currentPart = 0;

    public BasicItemTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
        Arrays.fill(this.buffer, ItemStack.field_190927_a);
    }

    @Override
    public EnumPartType getType() {
        return EnumPartType.BASIC_ITEM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (!this.filter.func_190926_b()) {
            nbt.func_74782_a("filter", (NBTBase)this.filter.serializeNBT());
        }
        if (this.boost > 0) {
            nbt.func_74774_a("boost", (byte)this.boost);
        }
        if (this.currentSlot > 0) {
            nbt.func_74768_a("current_slot", this.currentSlot);
        }
        if (this.cooldown > 0) {
            nbt.func_74774_a("cooldown", (byte)this.cooldown);
        }
        if (this.currentPart > 0) {
            nbt.func_74774_a("current_part", (byte)this.currentPart);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i].func_190926_b()) continue;
            NBTTagCompound nbt1 = this.buffer[i].serializeNBT();
            nbt1.func_74774_a("slot", (byte)i);
            list.func_74742_a((NBTBase)nbt1);
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a("buffer", (NBTBase)list);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.filter = nbt.func_74764_b("filter") ? new ItemStack(nbt.func_74775_l("filter")) : ItemStack.field_190927_a;
        this.boost = nbt.func_74771_c("boost") & 0xFF;
        this.currentSlot = nbt.func_74762_e("current_slot");
        if (this.currentSlot < 0) {
            this.currentSlot = 0;
        }
        this.cooldown = nbt.func_74771_c("cooldown") & 0xFF;
        this.currentPart = nbt.func_74771_c("current_part") & 0xFF;
        Arrays.fill(this.buffer, ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c("buffer", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            ItemStack stack = new ItemStack(nbt1);
            if (stack.func_190926_b()) continue;
            this.buffer[nbt1.func_74771_c((String)"slot")] = stack;
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
    }

    public void func_73660_a() {
        ItemStack stack1;
        IItemHandler outHandler;
        TileEntity outEntity;
        ItemStack stack;
        if (!this.outputMode) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = TesslocatorConfig.general.boost_starting - this.boost * TesslocatorConfig.general.boost_multiplier;
        int tempParts = 0;
        for (TesslocatorPart part : this.block.parts) {
            if (part == this || !(part instanceof BasicItemTesslocatorPart)) continue;
            BasicItemTesslocatorPart part1 = (BasicItemTesslocatorPart)part;
            if (part1.outputMode) continue;
            this.temp[tempParts] = part1;
            ++tempParts;
        }
        if (tempParts == 0) {
            return;
        }
        TileEntity tileEntity = this.block.func_145831_w().func_175625_s(this.block.func_174877_v().func_177972_a(this.facing));
        if (tileEntity == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing.func_176734_d());
        if (handler == null) {
            return;
        }
        int slots = handler.getSlots();
        if (slots <= 0) {
            return;
        }
        this.currentSlot %= slots;
        int originalSlot = this.currentSlot;
        if (originalSlot < 0) {
            originalSlot = 0;
        }
        while ((stack = handler.extractItem(this.currentSlot, 64, true)).func_190926_b() || !ItemFiltersAPI.filter((ItemStack)this.filter, (ItemStack)stack)) {
            this.currentSlot = (this.currentSlot + 1) % slots;
            if (this.currentSlot != originalSlot) continue;
            return;
        }
        int i = this.currentPart % tempParts;
        if (ItemFiltersAPI.filter((ItemStack)this.temp[i].filter, (ItemStack)stack) && (outEntity = this.block.func_145831_w().func_175625_s(this.block.func_174877_v().func_177972_a(this.temp[i].facing))) != null && (outHandler = (IItemHandler)outEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.temp[i].facing.func_176734_d())) != null && (stack1 = ItemHandlerHelper.insertItem((IItemHandler)outHandler, (ItemStack)stack, (boolean)false)).func_190916_E() != stack.func_190916_E()) {
            handler.extractItem(this.currentSlot, stack.func_190916_E() - stack1.func_190916_E(), false);
        }
        ++this.currentSlot;
        ++this.currentPart;
    }

    @Override
    public void onRightClick(EntityPlayer player, EnumHand hand) {
        ItemStack stack1 = player.func_184586_b(hand);
        if (!stack1.func_190926_b()) {
            IntOpenHashSet ores = new IntOpenHashSet(OreDictionary.getOreIDs((ItemStack)stack1));
            int add = 0;
            if (ores.contains(OreDictionary.getOreID((String)"dustGlowstone"))) {
                add = 1;
            } else if (ores.contains(OreDictionary.getOreID((String)"glowstone"))) {
                add = 4;
            }
            if (add > 0) {
                if (this.boost < TesslocatorConfig.general.boost_max) {
                    this.boost += add;
                    if (this.boost > TesslocatorConfig.general.boost_max) {
                        this.boost = TesslocatorConfig.general.boost_max;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack1.func_190918_g(1);
                    }
                }
                TextComponentString component = new TextComponentString(this.boost + " / " + TesslocatorConfig.general.boost_max);
                component.func_150256_b().func_150238_a(TextFormatting.GOLD);
                player.func_146105_b((ITextComponent)component, true);
                return;
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            this.outputMode = !this.outputMode;
            this.block.rerender();
        }
    }

    @Override
    public void drop(World world, BlockPos pos) {
        super.drop(world, pos);
        if (this.boost > 0) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151114_aO, this.boost));
        }
    }

    public int getSlots() {
        return this.buffer.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.buffer[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.buffer[slot];
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.buffer[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.block.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.buffer[slot];
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.buffer[slot] = ItemStack.field_190927_a;
                this.block.func_70296_d();
            }
            return existing;
        }
        if (!simulate) {
            this.buffer[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract));
            this.block.func_70296_d();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.buffer[slot] = stack;
    }
}

