/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ExternalBookContents;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.handler.AdvancementSyncHandler;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

public class Book {
    public static final String DEFAULT_MODEL = "patchouli:book_brown";
    public static final ModelResourceLocation DEFAULT_MODEL_RES = new ModelResourceLocation("patchouli:book_brown", "inventory");
    private static final Map<String, String> DEFAULT_MACROS = new HashMap<String, String>(){
        {
            this.put("$(list", "$(li");
            this.put("/$", "$()");
            this.put("<br>", "$(br)");
            this.put("$(item)", "$(#b0b)");
            this.put("$(thing)", "$(#490)");
        }
    };
    public transient BookContents contents;
    private transient boolean wasUpdated = false;
    public transient ModContainer owner;
    public transient ResourceLocation resourceLoc;
    public transient ModelResourceLocation modelResourceLoc;
    private transient ItemStack bookItem;
    public transient ResourceLocation bookResource;
    public transient ResourceLocation fillerResource;
    public transient ResourceLocation craftingResource;
    public transient int textColor;
    public transient int headerColor;
    public transient int nameplateColor;
    public transient int linkColor;
    public transient int linkHoverColor;
    public transient int progressBarColor;
    public transient int progressBarBackground;
    public transient boolean isExtension = false;
    public transient List<Book> extensions = new LinkedList<Book>();
    public transient Book extensionTarget;
    public transient boolean isExternal;
    public String name = "";
    @SerializedName(value="landing_text")
    public String landingText = "patchouli.gui.lexicon.landing_info";
    @SerializedName(value="advancement_namespaces")
    public List<String> advancementNamespaces = new ArrayList<String>();
    @SerializedName(value="book_texture")
    public String bookTexture = "patchouli:textures/gui/book_brown.png";
    @SerializedName(value="filler_texture")
    public String fillerTexture = "patchouli:textures/gui/page_filler.png";
    @SerializedName(value="crafting_texture")
    public String craftingTexture = "patchouli:textures/gui/crafting.png";
    public String model = "patchouli:book_brown";
    @SerializedName(value="text_color")
    public String textColorRaw = "000000";
    @SerializedName(value="header_color")
    public String headerColorRaw = "333333";
    @SerializedName(value="nameplate_color")
    public String nameplateColorRaw = "FFDD00";
    @SerializedName(value="link_color")
    public String linkColorRaw = "0000EE";
    @SerializedName(value="link_hover_color")
    public String linkHoverColorRaw = "8800EE";
    @SerializedName(value="progress_bar_color")
    public String progressBarColorRaw = "FFFF55";
    @SerializedName(value="progress_bar_background")
    public String progressBarBackgroundRaw = "DDDDDD";
    @SerializedName(value="open_sound")
    public String openSound = "patchouli:book_open";
    @SerializedName(value="flip_sound")
    public String flipSound = "patchouli:book_flip";
    @SerializedName(value="show_progress")
    public boolean showProgress = true;
    @SerializedName(value="index_icon")
    public String indexIconRaw = "";
    public String version = "0";
    public String subtitle = "";
    @SerializedName(value="creative_tab")
    public String creativeTab = "misc";
    @SerializedName(value="advancements_tab")
    public String advancementsTab = "";
    @SerializedName(value="dont_generate_book")
    public boolean noBook = false;
    @SerializedName(value="custom_book_item")
    public String customBookItem = "";
    @SerializedName(value="show_toasts")
    public boolean showToasts = true;
    @SerializedName(value="extend")
    public String extend = "";
    @SerializedName(value="allow_extensions")
    public boolean allowExtensions = true;
    public Map<String, String> macros = new HashMap<String, String>();

    public void build(ModContainer owner, ResourceLocation resource, boolean external) {
        this.owner = owner;
        this.resourceLoc = resource;
        this.isExternal = external;
        this.isExtension = !this.extend.isEmpty();
        this.advancementNamespaces.remove("minecraft");
        AdvancementSyncHandler.trackedNamespaces.addAll(this.advancementNamespaces);
        if (!this.isExtension) {
            this.modelResourceLoc = new ModelResourceLocation(this.model, "inventory");
            this.bookResource = new ResourceLocation(this.bookTexture);
            this.fillerResource = new ResourceLocation(this.fillerTexture);
            this.craftingResource = new ResourceLocation(this.craftingTexture);
            this.textColor = 0xFF000000 | Integer.parseInt(this.textColorRaw, 16);
            this.headerColor = 0xFF000000 | Integer.parseInt(this.headerColorRaw, 16);
            this.nameplateColor = 0xFF000000 | Integer.parseInt(this.nameplateColorRaw, 16);
            this.linkColor = 0xFF000000 | Integer.parseInt(this.linkColorRaw, 16);
            this.linkHoverColor = 0xFF000000 | Integer.parseInt(this.linkHoverColorRaw, 16);
            this.progressBarColor = 0xFF000000 | Integer.parseInt(this.progressBarColorRaw, 16);
            this.progressBarBackground = 0xFF000000 | Integer.parseInt(this.progressBarBackgroundRaw, 16);
            for (String m : DEFAULT_MACROS.keySet()) {
                if (this.macros.containsKey(m)) continue;
                this.macros.put(m, DEFAULT_MACROS.get(m));
            }
        }
    }

    public boolean usesAdvancements() {
        return !this.advancementNamespaces.isEmpty();
    }

    public String getModNamespace() {
        return this.resourceLoc.func_110624_b();
    }

    public ItemStack getBookItem() {
        if (this.bookItem == null) {
            this.bookItem = this.noBook ? ItemStackUtil.loadStackFromString(this.customBookItem) : ItemModBook.forBook(this);
        }
        return this.bookItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void markUpdated() {
        this.wasUpdated = true;
    }

    public boolean popUpdated() {
        boolean updated = this.wasUpdated;
        this.wasUpdated = false;
        return updated;
    }

    @SideOnly(value=Side.CLIENT)
    public void reloadContentsAndExtensions() {
        this.reloadContents();
        for (Book b : this.extensions) {
            b.reloadExtensionContents();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void reloadContents() {
        if (this.contents == null) {
            BookContents bookContents = this.contents = this.isExternal ? new ExternalBookContents(this) : new BookContents(this);
        }
        if (!this.isExtension) {
            this.contents.reload(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void reloadExtensionContents() {
        if (this.isExtension) {
            if (this.extensionTarget == null) {
                this.extensionTarget = BookRegistry.INSTANCE.books.get(new ResourceLocation(this.extend));
                if (this.extensionTarget == null) {
                    throw new IllegalArgumentException("Extension Book " + this.resourceLoc + " has no valid target");
                }
                if (!this.extensionTarget.allowExtensions) {
                    throw new IllegalArgumentException("Book " + this.extensionTarget.resourceLoc + " doesn't allow extensions, so " + this.resourceLoc + " can't resolve");
                }
                this.extensionTarget.extensions.add(this);
                this.contents.categories = this.extensionTarget.contents.categories;
                this.contents.entries = this.extensionTarget.contents.entries;
                this.contents.templates = this.extensionTarget.contents.templates;
                this.contents.recipeMappings = this.extensionTarget.contents.recipeMappings;
            }
            this.contents.reload(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void reloadLocks(boolean reset) {
        this.contents.entries.values().forEach(BookEntry::updateLockStatus);
        this.contents.categories.values().forEach(c -> c.updateLockStatus(true));
        if (reset) {
            this.popUpdated();
        }
    }

    public String getOwnerName() {
        return this.owner.getName();
    }
}

