/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.valve;

import cassiokf.industrialrenewal.IRSoundHandler;
import cassiokf.industrialrenewal.tileentity.valve.BlockValvePipeLarge;
import cassiokf.industrialrenewal.util.FluidTankUtils;
import cassiokf.industrialrenewal.util.enumproperty.EnumFaceRotation;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public class TileEntityValvePipeLarge
extends TileFluidHandler
implements IFluidHandler,
ITickable {
    private final Set<EnumFacing> enabledFacings = EnumSet.allOf(EnumFacing.class);
    private EnumFacing facing = EnumFacing.SOUTH;
    private EnumFaceRotation faceRotation = EnumFaceRotation.UP;
    private Boolean active = false;

    public TileEntityValvePipeLarge() {
        this.tank = new FluidTankUtils((TileEntity)this, 1000);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.func_145830_o()) {
            EnumFacing facetofill = this.getOutPutFace(this.func_145831_w(), this.func_174877_v());
            boolean Vactive = (Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockValvePipeLarge.ACTIVE);
            TileEntity tileEntityS = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facetofill));
            if (tileEntityS != null && !tileEntityS.func_145837_r() && Vactive) {
                IFluidHandler consumer;
                this.active = true;
                if (tileEntityS.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facetofill.func_176734_d()) && (consumer = (IFluidHandler)tileEntityS.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facetofill.func_176734_d())) != null) {
                    this.tank.drain(consumer.fill(this.tank.drain(this.tank.getCapacity(), false), true), true);
                }
            }
            if (!Vactive) {
                this.active = false;
            }
        }
    }

    public void playSwitchSound() {
        Random r = new Random();
        float pitch = r.nextFloat() * 0.40000004f + 0.8f;
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), IRSoundHandler.TILEENTITY_VALVE_CHANGE, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    public EnumFacing getOutPutFace(World world, BlockPos pos) {
        EnumFacing vFace = this.getFacing();
        EnumFaceRotation rFace = this.getFaceRotation();
        if (vFace == EnumFacing.NORTH && rFace == EnumFaceRotation.UP || vFace == EnumFacing.SOUTH && rFace == EnumFaceRotation.DOWN || vFace == EnumFacing.UP && rFace == EnumFaceRotation.UP || vFace == EnumFacing.DOWN && rFace == EnumFaceRotation.UP) {
            return EnumFacing.EAST;
        }
        if (vFace == EnumFacing.NORTH && rFace == EnumFaceRotation.DOWN || vFace == EnumFacing.SOUTH && rFace == EnumFaceRotation.UP || vFace == EnumFacing.UP && rFace == EnumFaceRotation.DOWN || vFace == EnumFacing.DOWN && rFace == EnumFaceRotation.DOWN) {
            return EnumFacing.WEST;
        }
        if (vFace == EnumFacing.NORTH && rFace == EnumFaceRotation.LEFT || vFace == EnumFacing.SOUTH && rFace == EnumFaceRotation.LEFT || vFace == EnumFacing.WEST && rFace == EnumFaceRotation.LEFT || vFace == EnumFacing.EAST && rFace == EnumFaceRotation.LEFT) {
            return EnumFacing.DOWN;
        }
        if (vFace == EnumFacing.NORTH && rFace == EnumFaceRotation.RIGHT || vFace == EnumFacing.SOUTH && rFace == EnumFaceRotation.RIGHT || vFace == EnumFacing.WEST && rFace == EnumFaceRotation.RIGHT || vFace == EnumFacing.EAST && rFace == EnumFaceRotation.RIGHT) {
            return EnumFacing.UP;
        }
        if (vFace == EnumFacing.EAST && rFace == EnumFaceRotation.UP || vFace == EnumFacing.WEST && rFace == EnumFaceRotation.DOWN || vFace == EnumFacing.UP && rFace == EnumFaceRotation.RIGHT || vFace == EnumFacing.DOWN && rFace == EnumFaceRotation.LEFT) {
            return EnumFacing.SOUTH;
        }
        if (vFace == EnumFacing.WEST && rFace == EnumFaceRotation.UP || vFace == EnumFacing.EAST && rFace == EnumFaceRotation.DOWN || vFace == EnumFacing.UP && rFace == EnumFaceRotation.LEFT || vFace == EnumFacing.DOWN && rFace == EnumFaceRotation.RIGHT) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.notifyBlockUpdate();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        int canAccept = resource.amount;
        if (canAccept <= 0) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.tank.getInfo().fluid, this.tank.getInfo().capacity)};
    }

    public boolean toggleFacing(EnumFacing facing) {
        if (this.enabledFacings.contains(facing)) {
            this.enabledFacings.remove(facing);
            return false;
        }
        this.enabledFacings.add(facing);
        return true;
    }

    public boolean disableFacing(EnumFacing facing) {
        if (this.enabledFacings.contains(facing)) {
            this.enabledFacings.remove(facing);
            return false;
        }
        return true;
    }

    public boolean activeFacing(EnumFacing facing) {
        if (this.enabledFacings.contains(facing)) {
            return false;
        }
        this.enabledFacings.add(facing);
        return true;
    }

    public boolean isFacingEnabled(@Nullable EnumFacing facing) {
        return this.enabledFacings.contains(facing) || facing == null;
    }

    public Set<EnumFacing> getEnabledFacings() {
        return this.enabledFacings;
    }

    private void notifyBlockUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyBlockUpdate();
    }

    public void func_145839_a(NBTTagCompound tag) {
        int[] enabledFacingIndices;
        super.func_145839_a(tag);
        this.facing = EnumFacing.func_82600_a((int)tag.func_74762_e("facing"));
        this.faceRotation = EnumFaceRotation.values()[tag.func_74762_e("faceRotation")];
        this.active = tag.func_74767_n("active");
        this.enabledFacings.clear();
        for (int index : enabledFacingIndices = tag.func_74759_k("EnabledFacings")) {
            this.enabledFacings.add(EnumFacing.func_82600_a((int)index));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int[] enabledFacingIndices = this.enabledFacings.stream().mapToInt(EnumFacing::func_176745_a).toArray();
        tag.func_74768_a("facing", this.facing.func_176745_a());
        tag.func_74768_a("faceRotation", this.faceRotation.ordinal());
        tag.func_74783_a("EnabledFacings", enabledFacingIndices);
        tag.func_74757_a("active", this.active.booleanValue());
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.isFacingEnabled(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.isFacingEnabled(facing)) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFaceRotation getFaceRotation() {
        return this.faceRotation;
    }

    public void setFaceRotation(EnumFaceRotation faceRotation) {
        this.faceRotation = faceRotation;
        this.func_70296_d();
    }
}

