/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.sensors.entitydetector;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.sensors.entitydetector.TileEntityEntityDetector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEntityDetector
extends BlockTileEntity<TileEntityEntityDetector> {
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final IProperty<EnumFacing> BASE = PropertyDirection.func_177714_a((String)"base");

    public BlockEntityDetector(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityEntityDetector) {
            this.OpenGUI(worldIn, pos, playerIn);
            playerIn.func_71029_a(StatList.field_188084_R);
        }
        return true;
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEntityDetector te = (TileEntityEntityDetector)world.func_175625_s(pos);
        return state.func_177226_a(BASE, (Comparable)te.getBlockFacing());
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != ((EnumFacing)state.func_177229_b(FACING)).func_176734_d();
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean active = (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)ACTIVE);
        if (!active) {
            return 0;
        }
        return 15;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, BASE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing theFace = placer.func_70093_af() ? facing.func_176734_d() : placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a(FACING, (Comparable)theFace).func_177226_a(BASE, (Comparable)facing.func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityEntityDetector te = (TileEntityEntityDetector)worldIn.func_175625_s(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b(BASE);
        te.setBlockFacing(facing);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Class<TileEntityEntityDetector> getTileEntityClass() {
        return TileEntityEntityDetector.class;
    }

    @Override
    @Nullable
    public TileEntityEntityDetector createTileEntity(World world, IBlockState state) {
        return new TileEntityEntityDetector();
    }
}

