/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.railroad.cargoloader;

import cassiokf.industrialrenewal.network.NetworkHandler;
import cassiokf.industrialrenewal.network.PacketCargoLoader;
import cassiokf.industrialrenewal.network.PacketReturnCargoLoader;
import cassiokf.industrialrenewal.tileentity.railroad.cargoloader.BlockCargoLoader;
import cassiokf.industrialrenewal.tileentity.railroad.railloader.BlockLoaderRail;
import cassiokf.industrialrenewal.tileentity.railroad.railloader.TileEntityLoaderRail;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityCargoLoader
extends TileEntityLockableLoot
implements IHopper,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;
    private long tickedGameTime;
    private waitEnum waitE;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void setBlockState(boolean value) {
        IBlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)oldState.func_177229_b((IProperty)BlockCargoLoader.LOADING) != value) {
            this.field_145850_b.func_175656_a(this.field_174879_c, oldState.func_177226_a((IProperty)BlockCargoLoader.LOADING, (Comparable)Boolean.valueOf(value)));
            this.onChange();
            this.func_70296_d();
        }
    }

    public waitEnum getWaitEnum() {
        if (this.waitE == null) {
            this.waitE = waitEnum.WAIT_FULL;
        }
        return this.waitE;
    }

    public void setWaitEnum(int value) {
        this.waitE = waitEnum.valueOf(value);
    }

    public void setNextWaitEnum(boolean value) {
        int old = this.getWaitEnum().intValue;
        if (value) {
            this.waitE = waitEnum.valueOf(old + 1);
        }
        this.onChange();
        this.func_70296_d();
    }

    private void onChange() {
        if (!this.field_145850_b.field_72995_K) {
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)new PacketCargoLoader(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketReturnCargoLoader(this));
        }
    }

    private EnumFacing getOutput() {
        if (!this.isUnload()) {
            return EnumFacing.DOWN;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        return ((EnumFacing)state.func_177229_b((IProperty)BlockCargoLoader.FACING)).func_176734_d();
    }

    private boolean isUnload() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        return (Boolean)state.func_177229_b((IProperty)BlockCargoLoader.UNLOAD);
    }

    private void letCartPass() {
        TileEntityLoaderRail te;
        if (this.getWaitEnum() == waitEnum.NEVER) {
            return;
        }
        if (this.isUnload()) {
            TileEntityLoaderRail te2;
            IBlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
            if (oldState.func_177230_c() instanceof BlockLoaderRail && (te2 = (TileEntityLoaderRail)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) != null) {
                te2.letItGo();
            }
            return;
        }
        IBlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (oldState.func_177230_c() instanceof BlockLoaderRail && (te = (TileEntityLoaderRail)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null) {
            te.letItGo();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        compound.func_74768_a("EnumConfig", this.waitE.intValue);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
        this.waitE = waitEnum.valueOf(compound.func_74762_e("EnumConfig"));
        super.func_145839_a(compound);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.hopper";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    protected boolean updateHopper() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown()) {
                boolean flag = false;
                if (!this.isInventoryEmpty()) {
                    flag = this.transferItemsOut();
                } else if (!this.isUnload() && this.getWaitEnum() == waitEnum.NO_ACTIVITY) {
                    this.letCartPass();
                }
                this.setBlockState(flag);
                if (!this.isFull()) {
                    flag = this.pullItems(this) || flag;
                } else if (this.isUnload() && this.getWaitEnum() == waitEnum.NO_ACTIVITY) {
                    this.letCartPass();
                }
                if (flag) {
                    this.setTransferCooldown(1);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        boolean load;
        IInventory iinventory = this.getInventoryForHopperTransfer();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = this.getOutput();
        boolean bl = load = !this.isUnload();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            if (load && (this.getWaitEnum() == waitEnum.WAIT_FULL || this.getWaitEnum() == waitEnum.NO_ACTIVITY)) {
                this.letCartPass();
            }
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = TileEntityCargoLoader.putStackInInventoryAllSlots((IInventory)this, iinventory, this.func_70298_a(i, 1), enumfacing);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        if (load && (this.getWaitEnum() == waitEnum.NO_ACTIVITY || this.getWaitEnum() == waitEnum.WAIT_FULL)) {
            this.letCartPass();
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean pullItems(IHopper hopper) {
        IInventory iinventory = TileEntityCargoLoader.getSourceInventory(hopper);
        boolean unloader = this.isUnload();
        if (iinventory != null) {
            EnumFacing enumfacing = this.getOutput();
            if (TileEntityCargoLoader.isInventoryEmpty(iinventory, enumfacing)) {
                if (unloader && (this.getWaitEnum() == waitEnum.WAIT_EMPTY || this.getWaitEnum() == waitEnum.NO_ACTIVITY)) {
                    this.letCartPass();
                }
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.func_180463_a(enumfacing)) {
                    if (!TileEntityCargoLoader.pullItemFromSlot(hopper, iinventory, i, enumfacing)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!TileEntityCargoLoader.pullItemFromSlot(hopper, iinventory, k, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityCargoLoader.getCaptureItems(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC())) {
                if (!TileEntityCargoLoader.putDropInInventoryAllSlots(null, (IInventory)hopper, entityitem)) continue;
                return true;
            }
        }
        if (unloader && this.getWaitEnum() == waitEnum.NO_ACTIVITY) {
            this.letCartPass();
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && TileEntityCargoLoader.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = TileEntityCargoLoader.putStackInInventoryAllSlots(inventoryIn, (IInventory)hopper, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    private static boolean putDropInInventoryAllSlots(IInventory source, IInventory destination, EntityItem entity) {
        boolean flag = false;
        if (entity == null) {
            return false;
        }
        ItemStack itemstack = entity.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityCargoLoader.putStackInInventoryAllSlots(source, destination, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            entity.func_70106_y();
        } else {
            entity.func_92058_a(itemstack1);
        }
        return flag;
    }

    private static ItemStack putStackInInventoryAllSlots(IInventory source, IInventory destination, ItemStack stack, @Nullable EnumFacing direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory isidedinventory = (ISidedInventory)destination;
            int[] aint = isidedinventory.func_180463_a(direction);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = TileEntityCargoLoader.insertStack(source, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = TileEntityCargoLoader.insertStack(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(IInventory source, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (TileEntityCargoLoader.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (TileEntityCargoLoader.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                TileEntityCargoLoader tileentityhopper1;
                if (flag1 && destination instanceof TileEntityCargoLoader && !(tileentityhopper1 = (TileEntityCargoLoader)destination).mayTransfer()) {
                    int k = 0;
                    if (source instanceof TileEntityCargoLoader) {
                        TileEntityCargoLoader tileentityhopper = (TileEntityCargoLoader)source;
                        if (tileentityhopper1.tickedGameTime >= tileentityhopper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentityhopper1.setTransferCooldown(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    private IInventory getInventoryForHopperTransfer() {
        EnumFacing enumfacing = this.getOutput();
        return TileEntityCargoLoader.getInventoryAtPosition(this.func_145831_w(), this.func_96107_aA() + (double)enumfacing.func_82601_c(), this.func_96109_aB() + (double)enumfacing.func_96559_d(), this.func_96108_aC() + (double)enumfacing.func_82599_e());
    }

    private static IInventory getSourceInventory(IHopper hopper) {
        return TileEntityCargoLoader.getInventoryAtPosition(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    private static List<EntityItem> getCaptureItems(World worldIn, double p_184292_1_, double p_184292_3_, double p_184292_5_) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(p_184292_1_ - 0.5, p_184292_3_, p_184292_5_ - 0.5, p_184292_1_ + 0.5, p_184292_3_ + 1.5, p_184292_5_ + 0.5), EntitySelectors.field_94557_a);
    }

    private static IInventory getInventoryAtPosition(World worldIn, double x, double y, double z) {
        List list;
        TileEntity tileentity;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.func_76128_c((double)x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        IBlockState state = worldIn.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_189418_a(worldIn, blockpos, true);
        }
        if (iinventory == null && !(list = worldIn.func_175674_a(null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelectors.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    private void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    private boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    public String func_174875_k() {
        return "minecraft:hopper";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerHopper(playerInventory, (IInventory)this, playerIn);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    public static enum waitEnum {
        WAIT_FULL(0),
        WAIT_EMPTY(1),
        NO_ACTIVITY(2),
        NEVER(3);

        public int intValue;

        private waitEnum(int value) {
            this.intValue = value;
        }

        public static waitEnum valueOf(int waitNo) {
            if (waitNo > waitEnum.values().length - 1) {
                waitNo = 0;
            }
            for (waitEnum l : waitEnum.values()) {
                if (l.intValue != waitNo) continue;
                return l;
            }
            throw new IllegalArgumentException("waitEnum not found");
        }
    }
}

