/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.fusebox;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.BlockFuseBoxConduitExtension;
import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.fusebox.BlockFuseBoxConnector;
import cassiokf.industrialrenewal.tileentity.fusebox.TileEntityFuseBox;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFuseBox
extends BlockTileEntity<TileEntityFuseBox> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool DOWNCONDUIT = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UPCONDUIT = PropertyBool.func_177716_a((String)"up");
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.125, 0.25, 0.3125, 0.875, 0.75);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.125, 0.25, 0.6875, 0.875, 0.75);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.125, 0.6875, 0.75, 0.875, 1.0);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.125, 0.3125, 0.75, 0.875, 0.0);

    public BlockFuseBox(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityFuseBox te = (TileEntityFuseBox)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            te.changeActivate();
            return true;
        }
        this.OpenGUI(world, pos, player);
        return true;
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean canConnectConduit(int side, IBlockAccess world, BlockPos pos) {
        BlockPos posoff = side == 0 ? pos.func_177972_a(EnumFacing.UP) : pos.func_177972_a(EnumFacing.DOWN);
        return world.func_180495_p(posoff).func_177230_c() instanceof BlockFuseBoxConduitExtension || world.func_180495_p(posoff).func_177230_c() instanceof BlockFuseBoxConnector;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)DOWNCONDUIT, (Comparable)Boolean.valueOf(this.canConnectConduit(1, world, pos))).func_177226_a((IProperty)UPCONDUIT, (Comparable)Boolean.valueOf(this.canConnectConduit(0, world, pos)));
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWNCONDUIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPCONDUIT, (Comparable)Boolean.valueOf(false));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, DOWNCONDUIT, UPCONDUIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_185899_b(source, pos).func_177229_b((IProperty)FACING)) {
            default: {
                return NORTH_BLOCK_AABB;
            }
            case SOUTH: {
                return SOUTH_BLOCK_AABB;
            }
            case EAST: {
                return EAST_BLOCK_AABB;
            }
            case WEST: 
        }
        return WEST_BLOCK_AABB;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Class<TileEntityFuseBox> getTileEntityClass() {
        return TileEntityFuseBox.class;
    }

    @Override
    @Nullable
    public TileEntityFuseBox createTileEntity(World world, IBlockState state) {
        return new TileEntityFuseBox();
    }
}

