/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.entity.EntitySteamLocomotive;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSteamLocomotive
implements IMessage {
    private boolean messageValid;
    private ItemStack stack;
    private int id;

    public PacketSteamLocomotive() {
        this.messageValid = false;
    }

    public PacketSteamLocomotive(ItemStack stack, int id) {
        this.stack = stack;
        this.id = id;
        this.messageValid = true;
    }

    public PacketSteamLocomotive(EntitySteamLocomotive entity) {
        this(entity.inventory.getStackInSlot(6), entity.func_145782_y());
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.id = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<PacketSteamLocomotive, IMessage> {
        public IMessage onMessage(PacketSteamLocomotive message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketSteamLocomotive message, MessageContext ctx) {
            EntitySteamLocomotive entity = (EntitySteamLocomotive)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            entity.inventory.setStackInSlot(6, message.stack);
        }
    }
}

