/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.tileentity.recordplayer.TileEntityRecordPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketRecordPlayer
implements IMessage {
    private boolean messageValid;
    private BlockPos pos;
    private ItemStack stack;
    private ItemStack stack1;
    private ItemStack stack2;
    private ItemStack stack3;

    public PacketRecordPlayer() {
        this.messageValid = false;
    }

    public PacketRecordPlayer(BlockPos pos, ItemStack stack, ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        this.stack = stack;
        this.stack1 = stack1;
        this.stack2 = stack2;
        this.stack3 = stack3;
        this.pos = pos;
        this.messageValid = true;
    }

    public PacketRecordPlayer(TileEntityRecordPlayer te) {
        this(te.func_174877_v(), te.inventory.getStackInSlot(0), te.inventory.getStackInSlot(1), te.inventory.getStackInSlot(2), te.inventory.getStackInSlot(3));
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.stack1 = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.stack2 = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.stack3 = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack1);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack2);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack3);
    }

    public static class Handler
    implements IMessageHandler<PacketRecordPlayer, IMessage> {
        public IMessage onMessage(PacketRecordPlayer message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketRecordPlayer message, MessageContext ctx) {
            TileEntityRecordPlayer te = (TileEntityRecordPlayer)Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            te.inventory.setStackInSlot(0, message.stack);
            te.inventory.setStackInSlot(1, message.stack1);
            te.inventory.setStackInSlot(2, message.stack2);
            te.inventory.setStackInSlot(3, message.stack3);
        }
    }
}

