/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.tileentity.sensors.entitydetector.TileEntityEntityDetector;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketEntityDetector
implements IMessage {
    private boolean messageValid;
    private BlockPos pos;
    private int distance;
    private int enumConfig;

    public PacketEntityDetector() {
        this.messageValid = false;
    }

    public PacketEntityDetector(BlockPos pos, int distance, int enumConfig) {
        this.distance = distance;
        this.pos = pos;
        this.enumConfig = enumConfig;
        this.messageValid = true;
    }

    public PacketEntityDetector(TileEntityEntityDetector te) {
        this(te.func_174877_v(), te.getDistance(), te.getEntityEnum().intValue);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.distance = buf.readInt();
            this.enumConfig = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.distance);
        buf.writeInt(this.enumConfig);
    }

    public static class Handler
    implements IMessageHandler<PacketEntityDetector, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketEntityDetector message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketEntityDetector message, MessageContext ctx) {
            TileEntityEntityDetector te = (TileEntityEntityDetector)Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (te != null) {
                te.setDistance(message.distance);
                te.setEntityEnum(message.enumConfig);
            }
        }
    }
}

