/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.rails;

import cassiokf.industrialrenewal.IRSoundHandler;
import cassiokf.industrialrenewal.blocks.rails.BlockNormalRailBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrossingRail
extends BlockNormalRailBase {
    private final long PERIOD = 3000L;
    private long lastTime = System.currentTimeMillis() - 3000L;

    public BlockCrossingRail(String name, CreativeTabs tab) {
        super(name, tab);
    }

    @Override
    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        super.onMinecartPass(world, cart, pos);
        long thisTime = System.currentTimeMillis();
        if (thisTime - this.lastTime >= 3000L) {
            this.lastTime = thisTime;
            world.func_184133_a(null, pos, IRSoundHandler.TILEENTITY_TRAINHORN, SoundCategory.BLOCKS, 2.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tile.industrialrenewal.crossing_rail.info", (Object[])new Object[0]));
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }
}

