/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.BlockColumn;
import cassiokf.industrialrenewal.blocks.BlockPillar;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRoof
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    protected static final AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockRoof(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_149713_g(255);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    private Boolean isEven(BlockPos pos) {
        Integer number = pos.func_177952_p();
        if (number % 2 == 0) {
            return true;
        }
        return false;
    }

    protected boolean isValidConnection(IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = world.func_180495_p(neighbourPos);
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection == EnumFacing.EAST || neighbourDirection == EnumFacing.WEST) {
            IBlockState dState = world.func_180495_p(ownPos.func_177972_a(EnumFacing.DOWN));
            IBlockState sState = world.func_180495_p(ownPos.func_177972_a(EnumFacing.SOUTH));
            IBlockState nState = world.func_180495_p(ownPos.func_177972_a(EnumFacing.NORTH));
            Block dBlock = dState.func_177230_c();
            Block sBlock = sState.func_177230_c();
            Block nBlock = nState.func_177230_c();
            if ((sBlock instanceof BlockRoof || sBlock instanceof BlockCatwalkLadder || sBlock.func_149686_d(sState)) && (nBlock instanceof BlockRoof || nBlock instanceof BlockCatwalkLadder || nBlock.func_149686_d(nState))) {
                return this.isEven(ownPos) != false && (nb instanceof BlockRoof || nb.func_149686_d(neighbourState) || nb instanceof BlockPillar || nb instanceof BlockColumn) && !dBlock.func_149686_d(dState);
            }
        }
        return neighbourDirection == EnumFacing.DOWN && nb.func_149686_d(neighbourState);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.isValidConnection(world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockRoof.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        if (this.isConnected(actualState, EnumFacing.DOWN) || this.isConnected(actualState, EnumFacing.EAST) || this.isConnected(actualState, EnumFacing.WEST)) {
            BlockRoof.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOT_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        if (this.isConnected(actualState, EnumFacing.DOWN) || this.isConnected(actualState, EnumFacing.EAST) || this.isConnected(actualState, EnumFacing.WEST)) {
            return FULL_AABB;
        }
        return BASE_AABB;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

