/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal;

import cassiokf.industrialrenewal.IRSoundHandler;
import cassiokf.industrialrenewal.blocks.ModBlocks;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.entity.EntityInit;
import cassiokf.industrialrenewal.entity.EntitySteamLocomotive;
import cassiokf.industrialrenewal.item.ModItems;
import cassiokf.industrialrenewal.network.NetworkHandler;
import cassiokf.industrialrenewal.proxy.CommonProxy;
import cassiokf.industrialrenewal.recipes.ModRecipes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="industrialrenewal", name="Industrial Renewal", version="0.8.1", guiFactory="cassiokf.industrialrenewal.config.IRConfigGuiFactory", updateJSON="https://raw.githubusercontent.com/Cassiobsk8/Industrial_Renewal/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class IndustrialRenewal {
    @Mod.Instance(value="industrialrenewal")
    public static IndustrialRenewal instance;
    @SidedProxy(clientSide="cassiokf.industrialrenewal.proxy.ClientProxy", serverSide="cassiokf.industrialrenewal.proxy.CommonProxy", modId="industrialrenewal")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        System.out.println("Industrial Renewal is loading preInit!");
        IRSoundHandler.registerSounds();
        EntityInit.registerEntities();
        IRConfig.preInit();
        proxy.preInit();
        NetworkHandler.init();
        proxy.registerRenderers();
        System.out.println("Done!");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("Industrial Renewal is loading init!");
        ModRecipes.init();
        proxy.Init();
        proxy.registerBlockRenderers();
        System.out.println("Done!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        System.out.println("Industrial Renewal is loading posInit!");
        System.out.println("Done!");
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModItems.register((IForgeRegistry<Item>)event.getRegistry());
            ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(ModelRegistryEvent event) {
            ModItems.registerModels();
            ModBlocks.registerItemModels();
        }

        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        }

        @SubscribeEvent
        public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
            if (event.getTarget() instanceof EntitySteamLocomotive) {
                if (!event.getWorld().field_72995_K) {
                    EntitySteamLocomotive entity = (EntitySteamLocomotive)event.getTarget();
                    int entityID = entity.func_145782_y();
                    FMLNetworkHandler.openGui((EntityPlayer)event.getEntityPlayer(), (Object)instance, (int)3, (World)event.getWorld(), (int)entityID, (int)0, (int)0);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityDrop(LivingDropsEvent event) {
            Random r;
            if (!(event.getEntity() instanceof EntityZombieVillager) || (r = new Random()).nextInt(100) < 25) {
                // empty if block
            }
        }
    }
}

