/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot.rule;

import com.mmyzd.nmsot.IntegerRange;
import com.mmyzd.nmsot.SpawningEntry;
import com.mmyzd.nmsot.rule.Rule;
import com.mmyzd.nmsot.rule.RuleSet;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;

public class RuleMoonPhase
extends Rule {
    private static final String[] PHASES = new String[]{"fullmoon", "waninggibbous", "lastquarter", "waningcrescent", "newmoon", "waxingcrescent", "firstquarter", "waxinggibbous"};
    private int lhs;
    private int rhs;

    public RuleMoonPhase(LinkedList<Character> s) throws Exception {
        block3: {
            this.lhs = -1000000007;
            this.rhs = -1000000007;
            RuleSet.nextPart(s);
            try {
                IntegerRange range = new IntegerRange(s);
                this.lhs = range.lhs;
                this.rhs = range.rhs;
            }
            catch (Exception e) {
                String token = RuleSet.getToken(s).toLowerCase();
                for (int i = 0; i < PHASES.length; ++i) {
                    if (!PHASES[i].equals(token)) continue;
                    this.lhs = i;
                    this.rhs = i;
                    break;
                }
                if (this.lhs != -1000000007) break block3;
                LogManager.getLogger((String)"nmsot").warn("No such moon phase range or name: " + token);
            }
        }
    }

    @Override
    public boolean apply(SpawningEntry entry) {
        int phase = entry.world.field_73011_w.func_76559_b(entry.world.func_72820_D());
        return this.lhs <= phase && phase <= this.rhs;
    }
}

