/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigQuestObject
extends ConfigValue {
    public static final String ID = "ftbquests_object";
    private final QuestFile file;
    private final HashSet<QuestObjectType> types;
    private QuestObjectBase object;

    public ConfigQuestObject(@Nullable QuestFile f, @Nullable QuestObjectBase o, Collection<QuestObjectType> t) {
        this.file = f == null ? FTBQuests.PROXY.getQuestFile(null) : f;
        this.object = o;
        this.types = new HashSet<QuestObjectType>(t);
    }

    public ConfigQuestObject(@Nullable QuestFile f, @Nullable QuestObjectBase o, QuestObjectType ... t) {
        this(f, o, Arrays.asList(t));
    }

    public boolean isValid(QuestObjectType type) {
        return this.types.contains((Object)type);
    }

    public boolean isValid(@Nullable QuestObjectBase object) {
        return this.isValid(object == null ? QuestObjectType.NULL : object.getObjectType());
    }

    public HashSet<QuestObjectType> getTypes() {
        return new HashSet<QuestObjectType>(this.types);
    }

    public String getID() {
        return ID;
    }

    public void setObject(@Nullable QuestObjectBase v) {
        this.object = v;
    }

    @Nullable
    public QuestObjectBase getObject() {
        return this.object;
    }

    public String getString() {
        this.object = this.getObject();
        return this.object == null ? "" : this.object.toString();
    }

    public boolean getBoolean() {
        return this.getObject() != null;
    }

    public int getInt() {
        this.object = this.getObject();
        return this.object == null ? 0 : this.object.id;
    }

    public ConfigQuestObject copy() {
        return new ConfigQuestObject(this.file, this.object, this.types);
    }

    public ITextComponent getStringForGUI() {
        this.object = this.getObject();
        if (this.object == null) {
            return new TextComponentString("");
        }
        return this.object.getDisplayName().func_150259_f();
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (inst.getCanEdit()) {
            new GuiSelectQuestObject(this, gui, callback).openGui();
        }
    }

    public void writeData(DataOut data) {
        int i = 0;
        for (QuestObjectType type : this.types) {
            i |= type.getFlag();
        }
        data.writeVarInt(i);
        data.writeInt(this.getInt());
    }

    public void readData(DataIn data) {
        this.types.clear();
        int i = data.readVarInt();
        for (QuestObjectType type : QuestObjectType.NAME_MAP) {
            if (!Bits.getFlag((int)i, (int)type.getFlag())) continue;
            this.types.add(type);
        }
        this.object = this.file.getBase(data.readInt());
        if (this.isValid(this.object)) {
            this.setObject(this.object);
        }
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        this.object = this.file.getBase(this.file.getID(string));
        if (this.isValid(this.object)) {
            if (!simulate) {
                this.setObject(this.object);
            }
            return true;
        }
        return false;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
        if (this.object != null) {
            list.add(TextFormatting.AQUA + "ID: " + TextFormatting.RESET + this.object);
        }
        if (this.types.size() == 1) {
            list.add(TextFormatting.AQUA + "Type: " + TextFormatting.RESET + I18n.func_135052_a((String)this.types.iterator().next().getTranslationKey(), (Object[])new Object[0]));
        } else {
            list.add(TextFormatting.AQUA + "Types:");
            for (QuestObjectType type : QuestObjectType.NAME_MAP) {
                if (!this.isValid(type)) continue;
                list.add("> " + I18n.func_135052_a((String)type.getTranslationKey(), (Object[])new Object[0]));
            }
        }
    }

    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigQuestObject) {
            this.types.clear();
            this.types.addAll(((ConfigQuestObject)value).types);
        }
        this.object = this.file.getBase(value.getInt());
        if (this.isValid(this.object)) {
            this.setObject(this.object);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.object = this.getObject();
        if (this.object != null) {
            nbt.func_74768_a(key, this.object.id);
        }
    }

    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.object = this.file.getBase(nbt.func_74762_e(key));
        if (this.isValid(this.object)) {
            this.setObject(this.object);
        }
    }
}

