/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class EnergyTask
extends QuestTask
implements ISingleLongValueTask {
    public long value = 1000L;
    public long maxInput = 0L;

    public EnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
        if (this.maxInput > 0L) {
            nbt.func_74772_a("max_input", this.maxInput);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
        if (this.value < 1L) {
            this.value = 1L;
        }
        this.maxInput = nbt.func_74763_f("max_input");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
        data.writeVarLong(this.maxInput);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
        this.maxInput = data.readVarLong();
    }

    @Override
    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentString(StringUtils.formatDouble((double)this.value, (boolean)true));
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1000L, 1L, Long.MAX_VALUE);
        config.addLong("max_input", () -> this.maxInput, v -> {
            this.maxInput = v;
        }, 0L, 0L, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.max_input", new Object[0]));
    }
}

