/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.Dependency;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.EnumVisibility;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class QuestChapter
extends QuestObject {
    public final QuestFile file;
    public final List<Dependency> dependencies;
    public final List<Quest> quests;
    public final List<String> description;

    public QuestChapter(QuestFile f) {
        this.file = f;
        this.description = new ArrayList<String>(0);
        this.dependencies = new ArrayList<Dependency>(0);
        this.quests = new ArrayList<Quest>();
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public QuestChapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (!this.description.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (String v : this.description) {
                list.func_74742_a((NBTBase)new NBTTagString(v));
            }
            nbt.func_74782_a("description", (NBTBase)list);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.description.clear();
        NBTTagList desc = nbt.func_150295_c("description", 8);
        for (int i = 0; i < desc.func_74745_c(); ++i) {
            this.description.add(desc.func_150307_f(i));
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.description, DataOut.STRING);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.description, DataIn.STRING);
    }

    public int getIndex() {
        return this.file.chapters.indexOf(this);
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            progress += quest.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            maxProgress += quest.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            progress += quest.getRelativeProgress(data);
        }
        return QuestChapter.fixRelativeProgress(progress, this.quests.size());
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (Quest quest : this.quests) {
            if (quest.canRepeat || quest.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    public boolean getOnlyHasRepeatableQuests() {
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> onlineMembers) {
        super.onCompleted(data, onlineMembers);
        new ObjectCompletedEvent.ChapterEvent(data, this).post();
        if (!this.getOnlyHasRepeatableQuests()) {
            for (EntityPlayerMP player : onlineMembers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        if (this.file.isComplete(data)) {
            this.file.onCompleted(data, onlineMembers);
        }
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        for (Quest quest : this.quests) {
            quest.changeProgress(data, type);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.unnamed", new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        this.file.chapters.add(this);
        if (!this.quests.isEmpty()) {
            for (Quest quest : ListUtils.clearAndCopy(this.quests)) {
                quest.onCreated();
            }
        }
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "chapters/" + this.getCodeString());
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("description", this.description, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
    }

    public EnumVisibility getVisibility(@Nullable ITeamData data) {
        Quest quest;
        EnumVisibility v = EnumVisibility.VISIBLE;
        Iterator<Quest> iterator = this.quests.iterator();
        while (iterator.hasNext() && !(v = v.strongest((quest = iterator.next()).getVisibility(data))).isInvisible()) {
        }
        return v;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
    }
}

