/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.jei;

import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.filters.ORFilter;
import com.latmod.mods.itemfilters.item.ItemFiltersItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;

public class QuestWrapper
implements IRecipeWrapper {
    public final Quest quest;
    public final String name;
    public final List<List<ItemStack>> input;
    public final List<List<ItemStack>> output;

    public QuestWrapper(Quest q) {
        ArrayList<ItemStack> list;
        ItemStack stack;
        Object object;
        this.quest = q;
        this.name = this.quest.getDisplayName().func_150254_d();
        this.input = new ArrayList<List<ItemStack>>(5);
        this.output = new ArrayList<List<ItemStack>>(5);
        if (this.quest.tasks.size() == 1) {
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
        }
        for (QuestTask task : this.quest.tasks) {
            if (task instanceof ItemTask) {
                ORFilter filter = new ORFilter();
                filter.items.addAll(((ItemTask)task).items);
                ArrayList list2 = new ArrayList();
                filter.getValidItems(list2);
                this.input.add(list2);
                continue;
            }
            object = task.getJEIFocus();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                list = new ArrayList<ItemStack>();
                ItemFiltersAPI.getValidItems((ItemStack)stack, list);
                this.input.add(list);
                continue;
            }
            if (task.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)task.getIcon()).getStack().func_77946_l();
                stack.func_151001_c(task.getDisplayName().func_150254_d());
                this.input.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack(Items.field_151159_an);
            stack.func_151001_c(task.getDisplayName().func_150254_d());
            stack.func_77983_a("icon", (NBTBase)new NBTTagString(task.getIcon().toString()));
            this.input.add(Collections.singletonList(stack));
        }
        if (this.quest.rewards.size() == 1) {
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
        }
        for (QuestReward reward : this.quest.rewards) {
            object = reward.getJEIFocus();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.field_190927_a;
            if (!stack.func_190926_b()) {
                this.output.add(Collections.singletonList(stack.func_77946_l()));
                continue;
            }
            if (reward instanceof RandomReward) {
                list = new ArrayList();
                RewardTable table = ((RandomReward)reward).getTable();
                if (table.hideTooltip) {
                    ItemStack unknown = new ItemStack(ItemFiltersItems.MISSING);
                    unknown.func_151001_c("Unknown Reward");
                    list.add(unknown);
                } else {
                    for (WeightedReward reward1 : table.rewards) {
                        Object object1 = reward1.reward.getJEIFocus();
                        if (!(object1 instanceof ItemStack)) continue;
                        list.add((ItemStack)object1);
                    }
                }
                this.output.add(list);
                continue;
            }
            if (reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.getIcon()).getStack().func_77946_l();
                stack.func_151001_c(reward.getDisplayName().func_150254_d());
                this.output.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack(Items.field_151159_an);
            stack.func_151001_c(reward.getDisplayName().func_150254_d());
            stack.func_77983_a("icon", (NBTBase)new NBTTagString(reward.getIcon().toString()));
            this.output.add(Collections.singletonList(stack));
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.input);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.output);
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = TextFormatting.UNDERLINE + this.quest.getDisplayName().func_150260_c();
        mc.field_71466_p.func_78276_b(s, (recipeWidth - mc.field_71466_p.func_78256_a(s)) / 2, 3, -14540254);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (mouseY >= 0 && mouseY < 20 && !ClientQuestFile.INSTANCE.disableGui) {
            ClientQuestFile.INSTANCE.questTreeGui.open(this.quest);
            return true;
        }
        return false;
    }
}

