/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.buildcraft;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MJTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_full.png");

    public MJTask(Quest quest) {
        super(quest);
        this.value = 10000000000L;
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.BUILDCRAFT_MJ;
    }

    @Override
    public String getMaxProgressString() {
        return StringUtils.formatDouble((double)((double)this.value / 1000000.0), (boolean)true);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.task.ftbquests.buildcraft_mj.text", new Object[]{StringUtils.formatDouble((double)((double)this.value / 1000000.0), (boolean)true)});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            double h1 = r * 30.0 / 32.0 * (double)h;
            double y1 = (double)y + (0.03125 + (1.0 - r) * 30.0 / 32.0) * (double)h;
            double v0 = 0.03125 + 0.9375 * (1.0 - r);
            double v1 = 0.96875;
            mc.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)x, y1 + h1, 0.0).func_187315_a(0.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1 + h1, 0.0).func_187315_a(1.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1, 0.0).func_187315_a(1.0, v0).func_181675_d();
            buffer.func_181662_b((double)x, y1, 0.0).func_187315_a(0.0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            x -= 0.0078125;
            w += 0.015625;
            h = r * 30.0 / 32.0;
            y = 0.03125 + (1.0 - r) * 30.0 / 32.0 - 0.5;
            y -= 0.0078125;
            h += 0.015625;
            z = -0.003;
            double u0 = 0.0;
            double v0 = 0.03125 + 0.9375 * (1.0 - r);
            double u1 = 1.0;
            double v1 = 0.96875;
            mc.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<MJTask>
    implements IMjReceiver {
        private Data(MJTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return StringUtils.formatDouble((double)((double)this.progress / 1000000.0), (boolean)true);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR;
        }

        @Override
        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR ? this : null);
        }

        public long getPowerRequested() {
            long add = ((MJTask)this.task).value - this.progress;
            if (((MJTask)this.task).maxInput > 0L) {
                add = Math.min(add, ((MJTask)this.task).maxInput);
            }
            return add;
        }

        public long receivePower(long microJoules, boolean simulate) {
            long add;
            if (microJoules > 0L && this.progress < ((MJTask)this.task).value && (add = Math.min(microJoules, this.getPowerRequested())) > 0L) {
                if (!simulate) {
                    this.progress += add;
                    this.sync();
                }
                return microJoules - add;
            }
            return microJoules;
        }

        public boolean canConnect(@Nonnull IMjConnector other) {
            return true;
        }
    }
}

