/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tehnut.harvest.BlockStack;
import tehnut.harvest.HarvestConfig;
import tehnut.harvest.IReplantHandler;
import tehnut.harvest.JsonConfigHandler;
import tehnut.harvest.ReplantHandlers;

@Mod(modid="harvest", name="Harvest", version="1.12-1.2.7-20", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.11,1.13)")
public class Harvest {
    public static final String MODID = "harvest";
    public static final String NAME = "Harvest";
    public static final String VERSION = "1.12-1.2.7-20";
    public static final Logger LOGGER = LogManager.getLogger((String)"Harvest");
    public static final Map<Block, IReplantHandler> CUSTOM_HANDLERS = new HashMap<Block, IReplantHandler>();
    public static final Method _GET_SEED = ReflectionHelper.findMethod(BlockCrops.class, (String)"getSeed", (String)"func_149866_i", (Class[])new Class[0]);
    public static HarvestConfig config;

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        JsonConfigHandler.init(Loader.instance().getConfigDir());
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
            if (event.getHand() != EnumHand.MAIN_HAND) {
                return;
            }
            BlockStack worldBlock = BlockStack.getStackFromPos(event.getWorld(), event.getPos());
            if (config.getCropMap().containsKey(worldBlock)) {
                if (CUSTOM_HANDLERS.containsKey(worldBlock.getBlock())) {
                    CUSTOM_HANDLERS.get(worldBlock.getBlock()).handlePlant(event.getWorld(), event.getPos(), worldBlock.getState(), event.getEntityPlayer(), event.getWorld().func_175625_s(event.getPos()));
                } else {
                    ReplantHandlers.CONFIG.handlePlant(event.getWorld(), event.getPos(), worldBlock.getState(), event.getEntityPlayer(), event.getWorld().func_175625_s(event.getPos()));
                }
                event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                event.setUseItem(Event.Result.DENY);
                event.getEntityPlayer().func_71020_j(config.getExhaustionPerHarvest());
            }
        }
    }
}

