/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.config;

import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.config.OldConfig;
import bre.smoothfont.config.PlayerConfig;
import bre.smoothfont.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CommonConfig {
    protected static final String configVersion = "6";
    protected Configuration config;
    public static GlobalConfig globalConfig = null;
    public static PlayerConfig playerConfig = null;
    public static CommonConfig currentConfig = null;
    public float fontScaleRoundingToleranceRate = 0.0f;
    public float charWidthFractionToRoundUpFloat = 0.5f;
    public float mipmapLodBiasFloat = 0.0f;
    public float overlayLodBiasFloat = 0.0f;
    public boolean enableInterpolation;
    public boolean enableAlphaBlend;
    public boolean enablePremultipliedAlpha;
    public boolean enableDouble;
    public boolean excludeIntMultiple;
    public double fontScaleRoundingTolerance;
    public boolean excludeHighMag;
    public double limitMagnification;
    public boolean alternativeInterpolation;
    public boolean removeScaleRestriction;
    public boolean disableSmallItalic;
    public boolean enableMipmap;
    public int mipmapLevel;
    public int mipmapLodBias;
    public int overlayLodBias;
    public int brightness;
    public boolean autoBrightness;
    public boolean useOSFont;
    public int shadowLength;
    public int blurReduction;
    public boolean allowNPOTTexture;
    public boolean enableAnisotropicFilter;
    public boolean forceUnicode;
    public int saveMemory;
    public double charWidthFractionToRoundUp;
    public boolean performanceMode;
    public int runMode;
    public boolean widthErrorCorrection;
    public int smoothShadowThreshold;
    public String fontName;
    public String secondaryFontName;
    public int primaryFontStyle;
    public int secondaryFontStyle;
    public int fontAntiAlias;
    public int fontEmphasis;
    public int fontResIndex;
    public boolean fontAutoSizing;
    public double fontSizeScaleFactor;
    public double widthFactorDefaultCharset;
    public double widthFactorUnicodeCharset;
    public int fontGap;
    public int fontSpaceWidth;
    public int fontTargetToReplace;
    public boolean fontAlignBaseline;
    public boolean fontDetailList;
    public int glyphImageMargin;
    public String sizeAdjustChars;
    private Property enableInterpolationProp;
    private Property enableAlphaBlendProp;
    private Property enablePremultipliedAlphaProp;
    private Property enableDoubleProp;
    private Property excludeIntMultipleProp;
    private Property fontScaleRoundingToleranceProp;
    private Property excludeHighMagProp;
    private Property limitMagnificationProp;
    private Property alternativeInterpolationProp;
    private Property removeScaleRestrictionProp;
    private Property disableSmallItalicProp;
    private Property enableMipmapProp;
    private Property mipmapLevelProp;
    private Property mipmapLodBiasProp;
    private Property overlayLodBiasProp;
    private Property brightnessProp;
    private Property autoBrightnessProp;
    private Property useOSFontProp;
    private Property shadowLengthProp;
    private Property blurReductionProp;
    private Property allowNPOTTextureProp;
    private Property enableAnisotropicFilterProp;
    private Property forceUnicodeProp;
    private Property saveMemoryProp;
    private Property charWidthFractionToRoundUpProp;
    private Property performanceModeProp;
    private Property runModeProp;
    private Property widthErrorCorrectionProp;
    private Property smoothShadowThresholdProp;
    private Property fontNameProp;
    private Property secondaryFontNameProp;
    private Property primaryFontStyleProp;
    private Property secondaryFontStyleProp;
    private Property fontAntiAliasProp;
    private Property fontEmphasisProp;
    private Property fontResIndexProp;
    private Property fontAutoSizingProp;
    private Property fontSizeScaleFactorProp;
    private Property widthFactorDefaultCharsetProp;
    private Property widthFactorUnicodeCharsetProp;
    private Property fontGapProp;
    private Property fontSpaceWidthProp;
    private Property fontTargetToReplaceProp;
    private Property fontAlignBaselineProp;
    private Property fontDetailListProp;
    private Property glyphImageMarginProp;
    private Property sizeAdjustCharsProp;
    protected boolean enableInterpolationDefault;
    protected boolean enableAlphaBlendDefault;
    protected boolean enablePremultipliedAlphaDefault;
    protected boolean enableDoubleDefault;
    protected boolean excludeIntMultipleDefault;
    protected double fontScaleRoundingToleranceDefault;
    protected boolean excludeHighMagDefault;
    protected double limitMagnificationDefault;
    protected boolean alternativeInterpolationDefault;
    protected boolean removeScaleRestrictionDefault;
    protected boolean disableSmallItalicDefault;
    protected boolean enableMipmapDefault;
    protected int mipmapLevelDefault;
    protected int mipmapLodBiasDefault;
    protected int overlayLodBiasDefault;
    protected int brightnessDefault;
    protected boolean autoBrightnessDefault;
    protected boolean useOSFontDefault;
    protected int shadowLengthDefault;
    protected int blurReductionDefault;
    protected boolean allowNPOTTextureDefault;
    protected boolean enableAnisotropicFilterDefault;
    protected boolean forceUnicodeDefault;
    protected int saveMemoryDefault;
    protected double charWidthFractionToRoundUpDefault;
    protected boolean performanceModeDefault;
    protected int runModeDefault;
    protected boolean widthErrorCorrectionDefault;
    protected int smoothShadowThresholdDefault;
    protected String fontNameDefault;
    protected String secondaryFontNameDefault;
    protected int primaryFontStyleDefault;
    protected int secondaryFontStyleDefault;
    protected int fontAntiAliasDefault;
    protected int fontEmphasisDefault;
    protected int fontResIndexDefault;
    protected boolean fontAutoSizingDefault;
    protected double fontSizeScaleFactorDefault;
    protected double widthFactorDefaultCharsetDefault;
    protected double widthFactorUnicodeCharsetDefault;
    protected int fontGapDefault;
    protected int fontSpaceWidthDefault;
    protected int fontTargetToReplaceDefault;
    protected boolean fontAlignBaselineDefault;
    protected boolean fontDetailListDefault;
    protected int glyphImageMarginDefault;
    protected String sizeAdjustCharsDefault;

    public CommonConfig(File configFile) {
        this.config = new Configuration(configFile, configVersion);
        try {
            this.loadConfig();
            this.preConvertVersion();
            this.readConfig();
            this.convertVersion();
        }
        catch (Exception e) {
            Logger.error("Configuration file access error.");
        }
        finally {
            this.saveConfig();
        }
    }

    public CommonConfig() {
    }

    protected void loadConfig() {
        this.config.load();
    }

    protected void initDefaultValues() {
        this.enableInterpolationDefault = true;
        this.enableAlphaBlendDefault = true;
        this.enablePremultipliedAlphaDefault = false;
        this.enableDoubleDefault = false;
        this.excludeIntMultipleDefault = true;
        this.fontScaleRoundingToleranceDefault = 0.5;
        this.excludeHighMagDefault = true;
        this.limitMagnificationDefault = 3.0;
        this.alternativeInterpolationDefault = false;
        this.removeScaleRestrictionDefault = true;
        this.disableSmallItalicDefault = false;
        this.enableMipmapDefault = true;
        this.mipmapLevelDefault = 4;
        this.mipmapLodBiasDefault = -3;
        this.overlayLodBiasDefault = -5;
        this.brightnessDefault = 3;
        this.autoBrightnessDefault = true;
        this.useOSFontDefault = false;
        this.shadowLengthDefault = 5;
        this.blurReductionDefault = 10;
        this.allowNPOTTextureDefault = false;
        this.enableAnisotropicFilterDefault = true;
        this.forceUnicodeDefault = false;
        this.saveMemoryDefault = 1;
        this.charWidthFractionToRoundUpDefault = 0.3333335;
        this.performanceModeDefault = false;
        this.runModeDefault = 0;
        this.widthErrorCorrectionDefault = true;
        this.smoothShadowThresholdDefault = 24;
        this.fontNameDefault = "SansSerif";
        this.secondaryFontNameDefault = "SansSerif";
        this.primaryFontStyle = 0;
        this.secondaryFontStyle = 0;
        this.fontAntiAliasDefault = 0;
        this.fontEmphasisDefault = 0;
        this.fontResIndexDefault = 3;
        this.fontAutoSizingDefault = true;
        this.fontSizeScaleFactorDefault = 1.0;
        this.widthFactorDefaultCharsetDefault = 1.0;
        this.widthFactorUnicodeCharsetDefault = 1.0;
        this.fontGapDefault = 0;
        this.fontSpaceWidthDefault = 0;
        this.fontTargetToReplaceDefault = 0;
        this.fontAlignBaselineDefault = true;
        this.fontDetailListDefault = false;
        this.glyphImageMarginDefault = 1;
        this.sizeAdjustCharsDefault = "";
    }

    protected void readConfig() {
        this.initDefaultValues();
        this.enableInterpolationProp = this.config.get("common", "enableInterpolation", this.enableInterpolationDefault, "Enable linear interpolation");
        this.enableAlphaBlendProp = this.config.get("common", "enableAlphaBlend", this.enableAlphaBlendDefault, "Enable alpha blending");
        this.enablePremultipliedAlphaProp = this.config.get("common", "enablePremultipliedAlpha", this.enablePremultipliedAlphaDefault, "Enable premultiplied alpha instead of straight alpha.");
        this.enableDoubleProp = this.config.get("common", "enableDouble", this.enableDoubleDefault, "Enable double rendering");
        this.excludeIntMultipleProp = this.config.get("common", "excludeIntMultiple", this.excludeIntMultipleDefault, "Disable interpolation for the integral multiple of default size.");
        this.fontScaleRoundingToleranceProp = this.config.get("common", "fontScaleRoundingTolerance", this.fontScaleRoundingToleranceDefault, "Tolerance (in percent) for rounding font scale to integer.(Default: 0.5)");
        this.excludeHighMagProp = this.config.get("common", "excludeHighMag", this.excludeHighMagDefault, "Disable interpolation for characters drawn with high magnification.");
        this.limitMagnificationProp = this.config.get("common", "limitMagnification", this.limitMagnificationDefault, "Disable interpolation for fonts above this magnification when excludeHighMag is enabled.(Default: 3.0)");
        this.alternativeInterpolationProp = this.config.get("common", "alternativeInterpolation", this.alternativeInterpolationDefault, "Experimental: Try interpolation for MOD original font renderer.");
        this.removeScaleRestrictionProp = this.config.get("common", "removeScaleRestriction", this.removeScaleRestrictionDefault, "Enable odd multiple GUI scale factors (x3,x5,...) when using unicode font.");
        this.disableSmallItalicProp = this.config.get("common", "disableSmallItalic", this.disableSmallItalicDefault, "Disable italic for small fonts.");
        this.enableMipmapProp = this.config.get("common", "enableMipmap", this.enableMipmapDefault, "Enable mipmap for fonts.");
        this.mipmapLevelProp = this.config.get("common", "mipmapLevel", this.mipmapLevelDefault, "Mipmap level.");
        this.mipmapLodBiasProp = this.config.get("common", "mipmapLodBias", this.mipmapLodBiasDefault, "Mipmap LOD bias.");
        this.overlayLodBiasProp = this.config.get("common", "overlayLodBias", this.overlayLodBiasDefault, "Mipmap LOD bias for overlay screen.");
        this.brightnessProp = this.config.get("common", "brightness", this.brightnessDefault, "Brightness correction level for interpolated fonts.");
        this.autoBrightnessProp = this.config.get("common", "autoBrightness", this.autoBrightnessDefault, "Automatic detection of brightness.");
        this.useOSFontProp = this.config.get("common", "useOSFont", this.useOSFontDefault, "Use the installed fonts in the operating system.");
        this.shadowLengthProp = this.config.get("common", "shadowLength", this.shadowLengthDefault, "Shadow length. (0~10)");
        this.blurReductionProp = this.config.get("common", "blurReduction", this.blurReductionDefault, "Enable a blur reduction for fonts less than or equal to the specified size.(0~16)");
        this.allowNPOTTextureProp = this.config.get("common", "allowNPOTTexture", this.allowNPOTTextureDefault, "Allow to use NPOT Texture in order to reduce resource consumption.");
        this.enableAnisotropicFilterProp = this.config.get("common", "enableAnisotropicFilter", this.enableAnisotropicFilterDefault, "Enable anisotropic filtering.");
        this.forceUnicodeProp = this.config.get("common", "forceUnicode", this.forceUnicodeDefault, "Force to use unicode font.");
        this.saveMemoryProp = this.config.get("common", "saveMemory", this.saveMemoryDefault, "To save memory and VRAM usage by adjusting some parameters when a large amount of memory or VRAM will be required.\n(0:off, 1:conservative, 2:moderate, 3:aggressive)");
        this.charWidthFractionToRoundUpProp = this.config.get("common", "charWidthFractionToRoundUp", this.charWidthFractionToRoundUpDefault, "This value is an option to adjust the rounding method of the character width that can be obtained by getCharWidth().\nThe character widths are rounded up if the fractions of the character width are equal to or more than this fraction value.\nOther character widths are rounded down. (Default: 0.3333335)");
        this.performanceModeProp = this.config.get("common", "performanceMode", this.performanceModeDefault, "Prioritize performance rather than quality.");
        this.runModeProp = this.config.get("common", "runMode", this.runModeDefault, "Select run mode. (0:Enable mod, 1:Disable mod, 2:Disable mod(Optimization only)");
        this.widthErrorCorrectionProp = this.config.get("common", "widthErrorCorrection", this.widthErrorCorrectionDefault, "Correct character width error in a normal precision mode as much as possible.");
        this.smoothShadowThresholdProp = this.config.get("common", "smoothShadowThreshold", this.smoothShadowThresholdDefault, "Shadows are rendered smoothly by using linear interpolation if the font resolution is more than or equal to this value.");
        this.fontNameProp = this.config.get("font", "fontName", this.fontNameDefault, "Primary font name.\n(The font installed in the system or existing in the externalFontPaths folders (default:<minecraft dir>/fontfiles).)");
        this.secondaryFontNameProp = this.config.get("font", "secondaryFontName", this.secondaryFontNameDefault, "Secondary font name. It is used if the character cannot be rendered with the primary font.\n(The font installed in the system or existing in the externalFontPaths folders (default:<minecraft dir>/fontfiles).)");
        this.primaryFontStyleProp = this.config.get("font", "primaryFontStyle", this.primaryFontStyleDefault, "Primary font style.(0:plain, 1:bold, 2:italic, 3:bold+italic)");
        this.secondaryFontStyleProp = this.config.get("font", "secondaryFontStyle", this.secondaryFontStyleDefault, "Secondary font style.(0:plain, 1:bold, 2:italic, 3:bold+italic)");
        this.fontAntiAliasProp = this.config.get("font", "fontAntiAlias", this.fontAntiAliasDefault, "Enable anti-alias for OS fonts.(0:off, 1:normal, 2:high precision)");
        this.fontEmphasisProp = this.config.get("font", "fontEmphasis", this.fontEmphasisDefault, "Enable emphasis for OS fonts. (0:off, 1:Ascii only, 2:Non-Ascii, 3:All)");
        this.fontResIndexProp = this.config.get("font", "fontResolution", this.fontResIndexDefault, "OS font resolution. (0:8px, 1:10px, 2:12px, 3:16px, 4:24px, 5:32px, 6:48px, 7:64px)");
        this.fontAutoSizingProp = this.config.get("font", "fontAutoSizing", this.fontAutoSizingDefault, "Enable automatic font size detection for the font resolution.");
        this.fontSizeScaleFactorProp = this.config.get("font", "fontSizeScaleFactor", this.fontSizeScaleFactorDefault, "Scaling factor of system font size.");
        this.widthFactorDefaultCharsetProp = this.config.get("font", "widthFactorDefaultCharset", this.widthFactorDefaultCharsetDefault, "Transform non-default font narrowly or widely for MC default charset.");
        this.widthFactorUnicodeCharsetProp = this.config.get("font", "widthFactorUnicodeCharset", this.widthFactorUnicodeCharsetDefault, "Transform non-default font narrowly or widely for unicode charset.");
        this.fontGapProp = this.config.get("font", "fontGap", this.fontGapDefault, "Font gap.");
        this.fontSpaceWidthProp = this.config.get("font", "fontSpaceWidth", this.fontSpaceWidthDefault, "Space width for system fonts.\n(0:space width specified by the primary font, 1~3:custom width, 4:Minecraft default width)");
        this.fontTargetToReplaceProp = this.config.get("font", "fontTargetToReplace", this.fontTargetToReplaceDefault, "Target to replace fonts. (0:Exclude special fonts specified by mods, 1:All fonts)");
        this.fontAlignBaselineProp = this.config.get("font", "fontAlignBaseline", this.fontAlignBaselineDefault, "Align baseline among different fonts.");
        this.fontDetailListProp = this.config.get("font", "fontDetailList", this.fontDetailListDefault, "Internal state.");
        this.glyphImageMarginProp = this.config.get("font", "glyphImageMargin", this.glyphImageMarginDefault, "Margin around the glyph image.");
        this.sizeAdjustCharsProp = this.config.get("font", "sizeAdjustmentChars", this.sizeAdjustCharsDefault, "The size of the font is determined so that the height and width of these characters will not protrude.");
        this.setOrder();
        this.setValues();
    }

    private void setOrder() {
        this.config.setCategoryPropertyOrder("font", new ArrayList<String>(Arrays.asList("fontName", "secondaryFontName", "primaryFontStyle", "secondaryFontStyle", "fontAntiAlias", "fontEmphasis", "fontResolution", "fontAutoSizing", "sizeAdjustmentChars", "fontSizeScaleFactor", "widthFactorDefaultCharset", "widthFactorUnicodeCharset", "fontGap", "fontSpaceWidth", "fontAlignBaseline", "fontTargetToReplace", "fontDetailList", "glyphImageMargin")));
    }

    private void setValues() {
        this.enableInterpolation = this.enableInterpolationProp.getBoolean();
        this.enableAlphaBlend = this.enableAlphaBlendProp.getBoolean();
        this.enablePremultipliedAlpha = this.enablePremultipliedAlphaProp.getBoolean();
        this.enableDouble = this.enableDoubleProp.getBoolean();
        this.excludeIntMultiple = this.excludeIntMultipleProp.getBoolean();
        this.fontScaleRoundingTolerance = this.fontScaleRoundingToleranceProp.getDouble();
        this.excludeHighMag = this.excludeHighMagProp.getBoolean();
        this.limitMagnification = this.limitMagnificationProp.getDouble();
        this.alternativeInterpolation = this.alternativeInterpolationProp.getBoolean();
        this.removeScaleRestriction = this.removeScaleRestrictionProp.getBoolean();
        this.disableSmallItalic = this.disableSmallItalicProp.getBoolean();
        this.enableMipmap = this.enableMipmapProp.getBoolean();
        this.mipmapLevel = this.mipmapLevelProp.getInt();
        this.mipmapLodBias = this.mipmapLodBiasProp.getInt();
        this.overlayLodBias = this.overlayLodBiasProp.getInt();
        this.brightness = this.brightnessProp.getInt();
        this.autoBrightness = this.autoBrightnessProp.getBoolean();
        this.useOSFont = this.useOSFontProp.getBoolean();
        this.shadowLength = this.shadowLengthProp.getInt();
        this.blurReduction = this.blurReductionProp.getInt();
        this.allowNPOTTexture = this.allowNPOTTextureProp.getBoolean();
        this.enableAnisotropicFilter = this.enableAnisotropicFilterProp.getBoolean();
        this.forceUnicode = this.forceUnicodeProp.getBoolean();
        this.saveMemory = this.saveMemoryProp.getInt();
        this.charWidthFractionToRoundUp = this.charWidthFractionToRoundUpProp.getDouble();
        this.performanceMode = this.performanceModeProp.getBoolean();
        this.runMode = this.runModeProp.getInt();
        this.widthErrorCorrection = this.widthErrorCorrectionProp.getBoolean();
        this.smoothShadowThreshold = this.smoothShadowThresholdProp.getInt();
        this.fontName = this.fontNameProp.getString();
        this.secondaryFontName = this.secondaryFontNameProp.getString();
        this.primaryFontStyle = this.primaryFontStyleProp.getInt();
        this.secondaryFontStyle = this.secondaryFontStyleProp.getInt();
        this.fontAntiAlias = this.fontAntiAliasProp.getInt();
        this.fontEmphasis = this.fontEmphasisProp.getInt();
        this.fontResIndex = this.fontResIndexProp.getInt();
        this.fontAutoSizing = this.fontAutoSizingProp.getBoolean();
        this.fontSizeScaleFactor = this.fontSizeScaleFactorProp.getDouble();
        this.widthFactorDefaultCharset = this.widthFactorDefaultCharsetProp.getDouble();
        this.widthFactorUnicodeCharset = this.widthFactorUnicodeCharsetProp.getDouble();
        this.fontGap = this.fontGapProp.getInt();
        this.fontSpaceWidth = this.fontSpaceWidthProp.getInt();
        this.fontTargetToReplace = this.fontTargetToReplaceProp.getInt();
        this.fontAlignBaseline = this.fontAlignBaselineProp.getBoolean();
        this.fontDetailList = this.fontDetailListProp.getBoolean();
        this.glyphImageMargin = this.glyphImageMarginProp.getInt();
        this.sizeAdjustChars = this.sizeAdjustCharsProp.getString();
        this.updateCalculatedValues();
    }

    public void updateCalculatedValues() {
        this.fontScaleRoundingToleranceRate = (float)this.fontScaleRoundingTolerance * 0.01f;
        this.charWidthFractionToRoundUpFloat = (float)this.charWidthFractionToRoundUp;
        this.mipmapLodBiasFloat = (float)this.mipmapLodBias / 10.0f;
        this.overlayLodBiasFloat = (float)this.overlayLodBias / 10.0f;
    }

    protected void saveConfig() {
        this.enableInterpolationProp.setValue(this.enableInterpolation);
        this.enableAlphaBlendProp.setValue(this.enableAlphaBlend);
        this.enablePremultipliedAlphaProp.setValue(this.enablePremultipliedAlpha);
        this.enableDoubleProp.setValue(this.enableDouble);
        this.excludeIntMultipleProp.setValue(this.excludeIntMultiple);
        this.fontScaleRoundingToleranceProp.setValue(this.fontScaleRoundingTolerance);
        this.excludeHighMagProp.setValue(this.excludeHighMag);
        this.limitMagnificationProp.setValue(this.limitMagnification);
        this.alternativeInterpolationProp.setValue(this.alternativeInterpolation);
        this.removeScaleRestrictionProp.setValue(this.removeScaleRestriction);
        this.disableSmallItalicProp.setValue(this.disableSmallItalic);
        this.enableMipmapProp.setValue(this.enableMipmap);
        this.mipmapLevelProp.setValue(this.mipmapLevel);
        this.mipmapLodBiasProp.setValue(this.mipmapLodBias);
        this.overlayLodBiasProp.setValue(this.overlayLodBias);
        this.brightnessProp.setValue(this.brightness);
        this.autoBrightnessProp.setValue(this.autoBrightness);
        this.useOSFontProp.setValue(this.useOSFont);
        this.shadowLengthProp.setValue(this.shadowLength);
        this.blurReductionProp.setValue(this.blurReduction);
        this.allowNPOTTextureProp.setValue(this.allowNPOTTexture);
        this.enableAnisotropicFilterProp.setValue(this.enableAnisotropicFilter);
        this.forceUnicodeProp.setValue(this.forceUnicode);
        this.saveMemoryProp.setValue(this.saveMemory);
        this.charWidthFractionToRoundUpProp.setValue(this.charWidthFractionToRoundUp);
        this.performanceModeProp.setValue(this.performanceMode);
        this.runModeProp.setValue(this.runMode);
        this.widthErrorCorrectionProp.setValue(this.widthErrorCorrection);
        this.smoothShadowThresholdProp.setValue(this.smoothShadowThreshold);
        this.fontNameProp.setValue(this.fontName);
        this.secondaryFontNameProp.setValue(this.secondaryFontName);
        this.primaryFontStyleProp.setValue(this.primaryFontStyle);
        this.secondaryFontStyleProp.setValue(this.secondaryFontStyle);
        this.fontAntiAliasProp.setValue(this.fontAntiAlias);
        this.fontEmphasisProp.setValue(this.fontEmphasis);
        this.fontResIndexProp.setValue(this.fontResIndex);
        this.fontAutoSizingProp.setValue(this.fontAutoSizing);
        this.fontSizeScaleFactorProp.setValue(this.fontSizeScaleFactor);
        this.widthFactorDefaultCharsetProp.setValue(this.widthFactorDefaultCharset);
        this.widthFactorUnicodeCharsetProp.setValue(this.widthFactorUnicodeCharset);
        this.fontGapProp.setValue(this.fontGap);
        this.fontSpaceWidthProp.setValue(this.fontSpaceWidth);
        this.fontTargetToReplaceProp.setValue(this.fontTargetToReplace);
        this.fontAlignBaselineProp.setValue(this.fontAlignBaseline);
        this.fontDetailListProp.setValue(this.fontDetailList);
        this.glyphImageMarginProp.setValue(this.glyphImageMargin);
        this.sizeAdjustCharsProp.setValue(this.sizeAdjustChars);
        this.config.save();
    }

    protected void resetConfig() {
        this.enableInterpolationProp.setToDefault();
        this.enableAlphaBlendProp.setToDefault();
        this.excludeIntMultipleProp.setToDefault();
        this.excludeHighMagProp.setToDefault();
        this.limitMagnificationProp.setToDefault();
        this.alternativeInterpolationProp.setToDefault();
        this.removeScaleRestrictionProp.setToDefault();
        this.enableMipmapProp.setToDefault();
        this.mipmapLodBiasProp.setToDefault();
        this.overlayLodBiasProp.setToDefault();
        this.brightnessProp.setToDefault();
        this.autoBrightnessProp.setToDefault();
        this.useOSFontProp.setToDefault();
        this.shadowLengthProp.setToDefault();
        this.forceUnicodeProp.setToDefault();
        this.blurReductionProp.setToDefault();
        this.allowNPOTTextureProp.setToDefault();
        this.enableAnisotropicFilterProp.setToDefault();
        this.performanceModeProp.setToDefault();
        this.runModeProp.setToDefault();
        this.fontNameProp.setToDefault();
        this.secondaryFontNameProp.setToDefault();
        this.primaryFontStyleProp.setToDefault();
        this.secondaryFontStyleProp.setToDefault();
        this.fontAntiAliasProp.setToDefault();
        this.fontEmphasisProp.setToDefault();
        this.fontResIndexProp.setToDefault();
        this.fontAutoSizingProp.setToDefault();
        this.fontSizeScaleFactorProp.setToDefault();
        this.widthFactorDefaultCharsetProp.setToDefault();
        this.widthFactorUnicodeCharsetProp.setToDefault();
        this.fontGapProp.setToDefault();
        this.fontSpaceWidthProp.setToDefault();
        this.fontTargetToReplaceProp.setToDefault();
        this.fontAlignBaselineProp.setToDefault();
        this.fontDetailListProp.setToDefault();
        this.sizeAdjustCharsProp.setToDefault();
        this.setValues();
        this.config.save();
    }

    protected void preConvertVersion() {
        if (this.getLoadedConfigVersionInt() <= 5) {
            this.config.moveProperty("common", "fontName", "font");
            this.config.moveProperty("common", "secondaryFontName", "font");
            this.config.moveProperty("common", "fontAntiAlias", "font");
            this.config.moveProperty("common", "fontEmphasis", "font");
            this.config.moveProperty("common", "fontResolution", "font");
            this.config.moveProperty("common", "fontAutoSizing", "font");
            this.config.moveProperty("common", "fontSizeScaleFactor", "font");
            this.config.moveProperty("common", "widthFactorDefaultCharset", "font");
            this.config.moveProperty("common", "widthFactorUnicodeCharset", "font");
            this.config.moveProperty("common", "fontGap", "font");
            this.config.moveProperty("common", "fontSpaceWidth", "font");
            this.config.moveProperty("common", "fontTargetToReplace", "font");
            this.config.moveProperty("common", "fontAlignBaseline", "font");
            this.config.moveProperty("common", "fontDetailList", "font");
            this.config.moveProperty("common", "glyphImageMargin", "font");
            this.config.moveProperty("common", "sizeAdjustmentChars", "font");
        }
    }

    protected void convertVersion() {
        if (this.getLoadedConfigVersionInt() <= 2 && this.saveMemory == 2) {
            this.saveMemory = 1;
        }
        if (this.getLoadedConfigVersionInt() <= 4 && this.fontGap != this.fontGapDefault) {
            this.fontGap += 2;
        }
        if (this.getLoadedConfigVersionInt() <= 5) {
            this.removeKey("common", "verticalMargin");
            this.removeKey("common", "horizontalMargin");
            this.removeKey("common", "fontSizeAdjustment");
        }
    }

    protected void removeKey(String category, String key) {
        if (this.config.hasKey(category, key)) {
            this.config.moveProperty(category, key, "work");
            this.config.removeCategory(this.config.getCategory("work"));
        }
    }

    protected void takeoverOldConfigValues() {
        this.enableInterpolation = OldConfig.enableInterpolation;
        this.enableAlphaBlend = OldConfig.enableAlphaBlend;
        this.enablePremultipliedAlpha = OldConfig.enablePremultipliedAlpha;
        this.enableDouble = OldConfig.enableDouble;
        this.excludeIntMultiple = OldConfig.excludeIntMultiple;
        this.fontScaleRoundingTolerance = OldConfig.fontScaleRoundingTolerance;
        this.excludeHighMag = OldConfig.excludeHighMag;
        this.limitMagnification = OldConfig.limitMagnification;
        this.alternativeInterpolation = OldConfig.alternativeInterpolation;
        this.removeScaleRestriction = OldConfig.removeScaleRestriction;
        this.disableSmallItalic = OldConfig.disableSmallItalic;
        this.enableMipmap = OldConfig.enableMipmap;
        this.mipmapLevel = OldConfig.mipmapLevel;
        this.mipmapLodBias = OldConfig.mipmapLodBias;
        this.overlayLodBias = OldConfig.overlayLodBias;
        this.brightness = OldConfig.brightness;
        this.autoBrightness = OldConfig.autoBrightness;
        this.useOSFont = OldConfig.useOSFont;
        this.fontName = OldConfig.fontName;
        this.secondaryFontName = OldConfig.secondaryFontName;
        this.fontAntiAlias = OldConfig.fontAntiAlias;
        this.fontEmphasis = OldConfig.fontEmphasis;
        this.fontResIndex = OldConfig.fontResIndex;
        this.fontAutoSizing = OldConfig.fontAutoSizing;
        this.fontGap = OldConfig.fontGap;
        this.fontAlignBaseline = OldConfig.fontAlignBaseline;
        this.fontDetailList = OldConfig.fontDetailList;
        this.sizeAdjustChars = OldConfig.sizeAdjustChars;
        this.shadowLength = OldConfig.shadowLength;
        this.blurReduction = OldConfig.blurReduction;
        this.allowNPOTTexture = OldConfig.allowNPOTTexture;
        this.enableAnisotropicFilter = OldConfig.enableAnisotropicFilter;
        this.forceUnicode = OldConfig.forceUnicode;
        this.updateCalculatedValues();
    }

    public static void saveCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.saveConfig();
        }
        globalConfig.saveConfig();
    }

    public static boolean isPlayerConfig() {
        return CommonConfig.globalConfig.enablePerPlayerConfig && playerConfig != null && CommonConfig.playerConfig.usePlayerConfig;
    }

    public static void resetCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.resetConfig();
        } else {
            globalConfig.resetConfig();
        }
    }

    public static void toggleConfig() {
        if (!CommonConfig.globalConfig.enablePerPlayerConfig) {
            return;
        }
        if (playerConfig == null) {
            PlayerConfig.readPlayerConfig();
        }
        if (playerConfig != null) {
            CommonConfig.playerConfig.usePlayerConfig = !CommonConfig.playerConfig.usePlayerConfig;
            currentConfig = CommonConfig.isPlayerConfig() ? playerConfig : globalConfig;
            playerConfig.saveConfig();
        }
    }

    public int getLoadedConfigVersionInt() {
        if (this.config.getLoadedConfigVersion() == null) {
            return 0;
        }
        return Integer.parseInt(this.config.getLoadedConfigVersion());
    }
}

