/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.mods.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.IGuideComponentWidget;
import java.awt.image.BufferedImage;
import java.util.List;

public class ImageGuideComponent
extends GuideComponent {
    public final Icon image;
    private int width;
    private int height;
    public String click = "";
    public String hover = "";

    public ImageGuideComponent(Icon i, int w, int h) {
        this.image = i;
        this.width = w;
        this.height = h;
    }

    public ImageGuideComponent(Icon i) {
        this.image = i;
        this.width = -1;
        this.height = -1;
    }

    @Override
    public String toString() {
        return this.image.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.image.isEmpty();
    }

    private void loadSizeFromImage() {
        block6: {
            if (this.width == -1 || this.height == -1) {
                try {
                    BufferedImage img = this.image.readImage();
                    if (this.width == -1) {
                        this.width = img.getWidth();
                    }
                    if (this.height == -1) {
                        this.height = img.getHeight();
                    }
                }
                catch (Exception ex) {
                    if (this.width == -1) {
                        this.width = 32;
                    }
                    if (this.height != -1) break block6;
                    this.height = 32;
                }
            }
        }
    }

    public int getWidth() {
        this.loadSizeFromImage();
        return this.width;
    }

    public int getHeight() {
        this.loadSizeFromImage();
        return this.height;
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new ImgWidget(parent, this);
    }

    public static class ImgWidget
    extends Widget
    implements IGuideComponentWidget {
        private final ImageGuideComponent component;

        public ImgWidget(ComponentPanel parent, ImageGuideComponent c) {
            super((Panel)parent);
            this.component = c;
            this.setWidth((int)((double)this.component.getWidth() / (double)this.getScreen().func_78325_e()));
            this.setHeight((int)((double)this.component.getHeight() / (double)this.getScreen().func_78325_e()));
            if (this.width > parent.maxWidth) {
                int w = Math.min(parent.maxWidth, this.width);
                double h = (double)this.height * ((double)w / (double)this.width);
                this.setWidth(w);
                this.setHeight(Math.max((int)h, 0));
            }
        }

        public void addMouseOverText(List<String> list) {
            if (!this.component.hover.isEmpty()) {
                list.add(this.component.hover);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && !this.component.click.isEmpty() && this.handleClick(this.component.click)) {
                GuiHelper.playClickSound();
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            this.component.image.draw(x, y, w, h);
        }
    }
}

