/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ItemStackNBTHelper {
    public static boolean hasTag(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemStackNBTHelper.hasTag(stack) && ItemStackNBTHelper.getTag(stack).func_74764_b(key);
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static void removeTag(ItemStack stack, String key) {
        if (ItemStackNBTHelper.hasKey(stack, key)) {
            ItemStackNBTHelper.getTag(stack).func_82580_o(key);
            if (ItemStackNBTHelper.getTag(stack).func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void setString(ItemStack stack, String key, String val) {
        ItemStackNBTHelper.getTag(stack).func_74778_a(key, val);
    }

    @Nullable
    public static String getString(ItemStack stack, String key, String defaultVal) {
        return ItemStackNBTHelper.hasTag(stack) ? ItemStackNBTHelper.getTag(stack).func_74779_i(key) : defaultVal;
    }

    public static void setLong(ItemStack stack, String key, long val) {
        ItemStackNBTHelper.getTag(stack).func_74772_a(key, val);
    }

    public static long getLong(ItemStack stack, String key, long defaultVal) {
        return ItemStackNBTHelper.hasTag(stack) ? ItemStackNBTHelper.getTag(stack).func_74763_f(key) : defaultVal;
    }

    public static void setInt(ItemStack stack, String key, int val) {
        ItemStackNBTHelper.getTag(stack).func_74768_a(key, val);
    }

    public static int getInt(ItemStack stack, String key, int defaultVal) {
        return ItemStackNBTHelper.hasTag(stack) ? ItemStackNBTHelper.getTag(stack).func_74762_e(key) : defaultVal;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultVal) {
        return ItemStackNBTHelper.hasTag(stack) ? ItemStackNBTHelper.getTag(stack).func_74767_n(key) : defaultVal;
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        ItemStackNBTHelper.getTag(stack).func_74757_a(key, value);
    }

    public static void setStringList(ItemStack stack, NonNullList<String> list, String key) {
        NBTTagList stringList = new NBTTagList();
        int index = 0;
        for (String s : list) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(index + "", s);
            stringList.func_74742_a((NBTBase)tag);
            ++index;
        }
        ItemStackNBTHelper.getTag(stack).func_74782_a(key, (NBTBase)stringList);
    }

    public static NonNullList<String> getStringList(ItemStack stack, String key) {
        NonNullList list = NonNullList.func_191196_a();
        if (stack.func_77942_o()) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c(key, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                list.add(i, (Object)tag.func_74779_i(i + ""));
            }
        }
        return list;
    }
}

