/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.hopperducts;

import java.util.List;
import javax.annotation.Nullable;
import net.fybertech.hopperducts.BlockGratedHopper;
import net.fybertech.hopperducts.BlockHopperDuct;
import net.fybertech.hopperducts.ContainerHopperDuct;
import net.fybertech.hopperducts.HopperDuctsMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityDuctObject
extends TileEntityLockable
implements IHopper,
ITickable,
ISidedInventory {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private String customName;
    private int transferCooldown = -1;
    private int totalCounter = 0;
    private final int visibleSlotCount;
    public final boolean isGratedHopper;
    private static final int[] slots_GratedHopper = new int[]{0, 1, 2, 3, 4};
    private static final int[] slots_filter = new int[]{5, 6, 7, 8, 9};
    private static final int[] slots_HopperDuct = new int[]{0};
    private IItemHandler itemHandler;

    public TileEntityDuctObject(boolean isGratedHopper) {
        this.isGratedHopper = isGratedHopper;
        this.visibleSlotCount = isGratedHopper ? 5 : 1;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public boolean func_145837_r() {
        return super.func_145837_r();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !(newSate.func_177230_c() instanceof BlockHopperDuct) && !(newSate.func_177230_c() instanceof BlockGratedHopper);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)(this.isGratedHopper ? this.visibleSlotCount * 2 : this.visibleSlotCount), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.size()) continue;
            this.inventory.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack == null || stack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70302_i_() {
        return this.visibleSlotCount;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.customName;
        }
        return this.isGratedHopper ? "container.gratedhopper" : "container.hopperduct";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String customNameIn) {
        this.customName = customNameIn;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            --this.transferCooldown;
            if (this.transferCooldown <= 0) {
                this.transferCooldown = HopperDuctsMod.cooldownTime;
                if (!BlockHopperDuct.isEnabled(this.func_145832_p())) {
                    return;
                }
                boolean contentChanged = false;
                if (!this.isDuctObjectEmpty()) {
                    contentChanged = this.pushOutItems();
                }
                if (!this.isDuctObjectFull() && this.isGratedHopper) {
                    boolean bl = contentChanged = this.pullInItems(this) || contentChanged;
                }
                if (contentChanged) {
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean isDuctObjectEmpty() {
        return this.func_191420_l();
    }

    private boolean isDuctObjectFull() {
        for (int n = 0; n < this.visibleSlotCount; ++n) {
            ItemStack itemstack = (ItemStack)this.inventory.get(n);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() >= itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean pushOutItems() {
        IInventory iinventory = this.getInventoryPointedTo();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = BlockHopperDuct.getFacing(this.func_145832_p()).func_176734_d();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        int isize = this.func_70302_i_();
        for (int i = 0; i < isize; ++i) {
            ItemStack stackInSlot = this.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !this.isValidFilterItem(stackInSlot)) continue;
            ItemStack itemstack = stackInSlot.func_77946_l();
            ItemStack itemstack1 = TileEntityDuctObject.putStackInInventoryAllSlots((IInventory)this, iinventory, this.func_70298_a(i, 1), enumfacing);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean pullInItems(IHopper hopper) {
        IInventory iinventory = TileEntityHopper.func_145893_b((World)hopper.func_145831_w(), (double)hopper.func_96107_aA(), (double)(hopper.func_96109_aB() + 1.0), (double)hopper.func_96108_aC());
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileEntityDuctObject.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.func_180463_a(enumfacing)) {
                    if (!this.pullItemFromSlot(hopper, iinventory, i, enumfacing)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!this.pullItemFromSlot(hopper, iinventory, k, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityHopper.func_184292_a((World)hopper.func_145831_w(), (double)hopper.func_96107_aA(), (double)hopper.func_96109_aB(), (double)hopper.func_96108_aC())) {
                if (!TileEntityDuctObject.putDropInInventoryAllSlots(null, (IInventory)hopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && TileEntityDuctObject.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = TileEntityDuctObject.putStackInInventoryAllSlots(inventoryIn, (IInventory)hopper, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    public static boolean putDropInInventoryAllSlots(IInventory inventoryIn, IInventory itemIn, EntityItem itemEntityIn) {
        boolean flag = false;
        if (itemEntityIn == null) {
            return false;
        }
        ItemStack itemstack = itemEntityIn.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityDuctObject.putStackInInventoryAllSlots(inventoryIn, itemIn, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            itemEntityIn.func_70106_y();
        } else {
            itemEntityIn.func_92058_a(itemstack1);
        }
        return flag;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, IInventory stack, ItemStack side, @Nullable EnumFacing facingIn) {
        if (stack instanceof ISidedInventory && facingIn != null) {
            ISidedInventory isidedinventory = (ISidedInventory)stack;
            int[] aint = isidedinventory.func_180463_a(facingIn);
            for (int k = 0; k < aint.length && !side.func_190926_b(); ++k) {
                side = TileEntityDuctObject.insertStack(inventoryIn, stack, side, aint[k], facingIn);
            }
        } else {
            int i = stack.func_70302_i_();
            for (int j = 0; j < i && !side.func_190926_b(); ++j) {
                side = TileEntityDuctObject.insertStack(inventoryIn, stack, side, j, facingIn);
            }
        }
        return side;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stackIn, int countIn, EnumFacing facingIn) {
        return !inventoryIn.func_94041_b(countIn, stackIn) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(countIn, stackIn, facingIn);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stackIn, int countIn, EnumFacing facingIn) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(countIn, stackIn, facingIn);
    }

    private static ItemStack insertStack(IInventory inventoryIn, IInventory stack, ItemStack index, int side, EnumFacing facingIn) {
        ItemStack itemstack = stack.func_70301_a(side);
        if (TileEntityDuctObject.canInsertItemInSlot(stack, index, side, facingIn)) {
            boolean flag = false;
            boolean flag1 = stack.func_191420_l();
            if (itemstack.func_190926_b()) {
                stack.func_70299_a(side, index);
                index = ItemStack.field_190927_a;
                flag = true;
            } else if (TileEntityDuctObject.canCombine(itemstack, index)) {
                int i = index.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(index.func_190916_E(), i);
                index.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag && inventoryIn != null) {
                if (inventoryIn instanceof TileEntityDuctObject) {
                    TileEntityDuctObject tileentityhopper = (TileEntityDuctObject)inventoryIn;
                    if (tileentityhopper.mayTransfer()) {
                        tileentityhopper.setTransferCooldown(8);
                    }
                    inventoryIn.func_70296_d();
                }
                inventoryIn.func_70296_d();
            }
        }
        return index;
    }

    private IInventory getInventoryPointedTo() {
        EnumFacing enumfacing = BlockHopperDuct.getFacing(this.func_145832_p());
        return TileEntityDuctObject.getInventoryAtLocation(this.func_145831_w(), this.field_174879_c.func_177958_n() + enumfacing.func_82601_c(), this.field_174879_c.func_177956_o() + enumfacing.func_96559_d(), this.field_174879_c.func_177952_p() + enumfacing.func_82599_e());
    }

    public static IInventory getInventoryAtLocation(World worldIn, double x, double y, double z) {
        List list;
        Block block;
        IInventory object = null;
        int floorX = MathHelper.func_76128_c((double)x);
        int floorY = MathHelper.func_76128_c((double)y);
        int floorZ = MathHelper.func_76128_c((double)z);
        BlockPos blockpos = new BlockPos(floorX, floorY, floorZ);
        TileEntity tileentity = worldIn.func_175625_s(new BlockPos(floorX, floorY, floorZ));
        if (tileentity instanceof IInventory && (object = (IInventory)tileentity) instanceof TileEntityChest && (block = worldIn.func_180495_p(new BlockPos(floorX, floorY, floorZ)).func_177230_c()) instanceof BlockChest) {
            object = ((BlockChest)block).func_180676_d(worldIn, blockpos);
        }
        if (object == null && (list = worldIn.func_175674_a((Entity)null, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0), EntitySelectors.field_96566_b)).size() > 0) {
            object = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return object;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.func_190916_E() > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public double func_96107_aA() {
        return this.field_174879_c.func_177958_n();
    }

    public double func_96109_aB() {
        return this.field_174879_c.func_177956_o();
    }

    public double func_96108_aC() {
        return this.field_174879_c.func_177952_p();
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown <= 1;
    }

    public String func_174875_k() {
        return "hopperducts:hopperduct";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerHopperDuct(playerInventory, (IInventory)this, playerIn);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_191420_l() {
        for (int n = 0; n < this.visibleSlotCount; ++n) {
            if (((ItemStack)this.inventory.get(n)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            ItemStack itemstack = (ItemStack)this.inventory.get(index);
            this.inventory.set(index, (Object)ItemStack.field_190927_a);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.visibleSlotCount; ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private boolean isValidFilterItem(ItemStack itemstack) {
        if (!this.isGratedHopper) {
            return true;
        }
        for (int n = this.visibleSlotCount; n < this.visibleSlotCount * 2; ++n) {
            ItemStack currentStack = (ItemStack)this.inventory.get(n);
            if (currentStack.func_190926_b() || currentStack.func_77973_b() != itemstack.func_77973_b() || currentStack.func_77952_i() != itemstack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.isGratedHopper) {
            return slots_GratedHopper;
        }
        return slots_HopperDuct;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (!this.isGratedHopper) {
            return true;
        }
        int j = -1;
        if (direction != null) {
            j = direction.ordinal();
        }
        if (j == -1 || j == 1) {
            return this.isValidFilterItem(itemStackIn);
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (!this.isGratedHopper) {
            return true;
        }
        return !this.isValidFilterItem(stack);
    }

    protected IItemHandler createInvHandler() {
        return new InvWrapper((IInventory)this){

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack != null && !stack.func_190926_b() && TileEntityDuctObject.this.isGratedHopper && TileEntityDuctObject.this.isValidFilterItem(stack)) {
                    return ItemStack.field_190927_a;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createInvHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

