/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile;

import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nullable;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementMysticalMechanics;
import modulardiversity.tile.base.TileEntityMysticalMechanics;
import modulardiversity.util.ICraftingResourceHolder;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IMechCapability;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileMysticalMechanicsOutput
extends TileEntityMysticalMechanics
implements ITickable {
    public int keepPowerTicks;

    @Override
    protected IMechCapability initCapability() {
        return new DefaultMechCapability();
    }

    @Override
    public boolean consume(RequirementMysticalMechanics.ResourceToken token, boolean doConsume) {
        return false;
    }

    @Override
    public boolean generate(RequirementMysticalMechanics.ResourceToken token, boolean doGenerate) {
        if (doGenerate) {
            if (this.capability.getPower(null) != token.getOutputLevel()) {
                this.capability.setPower(token.getOutputLevel(), null);
            }
            this.keepPowerTicks = 20;
        }
        token.setRequiredlevelMet();
        return true;
    }

    public void func_73660_a() {
        this.keepPowerTicks = Math.max(0, this.keepPowerTicks - 1);
        if (this.keepPowerTicks <= 0 && this.capability.getPower(null) > 0.0) {
            this.capability.setPower(0.0, null);
        }
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponents.MysticalMechanicsHatch(MachineComponent.IOType.OUTPUT){

            public ICraftingResourceHolder<RequirementMysticalMechanics.ResourceToken> getContainerProvider() {
                return TileMysticalMechanicsOutput.this;
            }
        };
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        DefaultMechCapability capability = (DefaultMechCapability)this.capability;
        capability.power = compound.func_74769_h("mech_power");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        DefaultMechCapability capability = (DefaultMechCapability)this.capability;
        compound.func_74780_a("mech_power", capability.power);
    }
}

