/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile;

import buildcraft.api.mj.ILaserTarget;
import buildcraft.api.mj.MjAPI;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import javax.annotation.Nullable;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementLaser;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="buildcraft.api.mj.ILaserTarget", modid="buildcraftlib")
public class TileLaserInput
extends TileColorableMachineComponent
implements MachineComponentTile,
ILaserTarget,
ITickable,
ICraftingResourceHolder<RequirementLaser.ResourceToken> {
    private static final long MJ_FLOW_ROUND = MjAPI.MJ / 10L;
    public long power;
    public long demandedPower;
    public ResourceLocation lastRecipe;

    @Optional.Method(modid="buildcraftlib")
    public long getRequiredLaserPower() {
        return this.demandedPower - this.power;
    }

    @Optional.Method(modid="buildcraftlib")
    public long receiveLaserPower(long laserPower) {
        long received = Math.min(laserPower, this.getRequiredLaserPower());
        this.power += received;
        return laserPower - received;
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean isInvalidTarget() {
        return this.func_145837_r();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.demandedPower <= this.power) {
            this.power = this.demandedPower;
        }
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponents.LaserHatch(MachineComponent.IOType.INPUT){

            public ICraftingResourceHolder<RequirementLaser.ResourceToken> getContainerProvider() {
                return TileLaserInput.this;
            }

            @Override
            public void reset() {
                TileLaserInput.this.demandedPower = 0L;
            }
        };
    }

    @Override
    public boolean consume(RequirementLaser.ResourceToken token, boolean doConsume) {
        if (token.getRecipe().getRegistryName() != this.lastRecipe) {
            this.lastRecipe = token.getRecipe().getRegistryName();
            this.demandedPower = token.getRequiredMicroMJ();
        }
        long consumedMicroMJ = Math.min(token.getRequiredMicroMJ(), this.power);
        token.setRequiredMicroMJ(token.getRequiredMicroMJ() - consumedMicroMJ);
        if (doConsume) {
            this.power -= consumedMicroMJ;
        }
        return consumedMicroMJ > 0L;
    }

    @Override
    public boolean generate(RequirementLaser.ResourceToken token, boolean doGenerate) {
        return false;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.power = compound.func_74763_f("power");
        this.demandedPower = compound.func_74763_f("demandedPower");
        if (compound.func_74764_b("lastRecipe")) {
            this.lastRecipe = new ResourceLocation(compound.func_74779_i("lastRecipe"));
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74772_a("power", this.power);
        compound.func_74772_a("demanded_power", this.demandedPower);
        if (this.lastRecipe != null) {
            compound.func_74778_a("lastRecipe", this.lastRecipe.toString());
        }
    }
}

