/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import io.netty.buffer.ByteBuf;

public class BlockDimensionalPosition {
    private final int dim;
    private final int x;
    private final int y;
    private final int z;
    private final int hashcode;

    public BlockDimensionalPosition(int dim, int x, int y, int z) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.hashcode = ((this.dim * 41 + this.x) * 167 + this.y) * 331 + this.z;
    }

    public BlockDimensionalPosition(ByteBuf buf) {
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.hashcode = ((this.dim * 41 + this.x) * 167 + this.y) * 331 + this.z;
    }

    public int getDim() {
        return this.dim;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public String toString() {
        return String.format("[D:%d X:%8d Y:%3d Z:%8d]", this.dim, this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockDimensionalPosition) {
            BlockDimensionalPosition other = (BlockDimensionalPosition)obj;
            return this.dim == other.dim && this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

