/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import cpw.mods.fml.common.IWorldGenerator;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.ChorusFlower;
import ganymedes01.etfuturum.world.OceanMonument;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;

public class EtFuturumWorldGenerator
implements IWorldGenerator {
    private final List<WorldGenMinable> generators = new LinkedList<WorldGenMinable>();

    public EtFuturumWorldGenerator() {
        this.generators.add(new WorldGenMinable(ModBlocks.stone, 1, EtFuturum.maxStonesPerCluster, Blocks.field_150348_b));
        this.generators.add(new WorldGenMinable(ModBlocks.stone, 3, EtFuturum.maxStonesPerCluster, Blocks.field_150348_b));
        this.generators.add(new WorldGenMinable(ModBlocks.stone, 5, EtFuturum.maxStonesPerCluster, Blocks.field_150348_b));
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int x;
        if (EtFuturum.enableCoarseDirt && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
            for (x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
                for (int z2 = chunkZ * 16; z2 < chunkZ * 16 + 16; ++z2) {
                    for (int y = 0; y < world.func_72940_L(); ++y) {
                        if (world.func_147439_a(x, y, z2) != Blocks.field_150346_d || world.func_72805_g(x, y, z2) != 1) continue;
                        world.func_147465_d(x, y, z2, ModBlocks.coarse_dirt, 0, 2);
                    }
                }
            }
        }
        if (EtFuturum.enableStones && EtFuturum.maxStonesPerCluster > 0 && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
            for (WorldGenMinable generator : this.generators) {
                for (int i = 0; i < 10; ++i) {
                    int x2 = chunkX * 16 + rand.nextInt(16);
                    int y = rand.nextInt(80);
                    int z3 = chunkZ * 16 + rand.nextInt(16);
                    generator.func_76484_a(world, rand, x2, y, z3);
                }
            }
        }
        if (EtFuturum.enablePrismarine && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1 && OceanMonument.canSpawnAt(world, chunkX, chunkZ)) {
            int y;
            x = chunkX * 16 + rand.nextInt(16);
            z = chunkZ * 16 + rand.nextInt(16);
            for (y = 256; y > 0 && world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z); --y) {
            }
            int monumentCeiling = y - (1 + rand.nextInt(3));
            OceanMonument.buildTemple(world, x, monumentCeiling - 22, z);
            return;
        }
        if (EtFuturum.enableChorusFruit && world.field_73011_w.field_76574_g == 1) {
            int y;
            x = chunkX * 16 + rand.nextInt(16);
            z = chunkZ * 16 + rand.nextInt(16);
            for (y = 256; y > 0 && world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z); --y) {
            }
            if (y > 0 && ChorusFlower.canPlantStay(world, x, y + 1, z)) {
                EtFuturumWorldGenerator.generateChorusPlant(world, x, y + 1, z, 0);
            }
        }
    }

    public static void generateChorusPlant(World world, int x, int y, int z, int pass) {
        int height;
        for (height = 0; height < 4; ++height) {
            if (!ChorusFlower.canPlantStay(world, x, y + height, z)) {
                world.func_147465_d(x, y + height, z, ModBlocks.chorus_flower, 5, 2);
                break;
            }
            world.func_147449_b(x, y + height, z, ModBlocks.chorus_plant);
        }
        if (height > 1) {
            world.func_147449_b(x, y + height, z, ModBlocks.chorus_plant);
            boolean grew = false;
            if (pass < 5) {
                ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
                for (int j = 0; j < world.field_73012_v.nextInt(4); ++j) {
                    ForgeDirection dir = dirs[world.field_73012_v.nextInt(dirs.length)];
                    int xx = x + dir.offsetX;
                    int yy = y + height + dir.offsetY;
                    int zz = z + dir.offsetZ;
                    if (!world.func_147437_c(xx, yy, zz) || !ChorusFlower.isSpaceAroundFree(world, xx, yy, zz, dir.getOpposite())) continue;
                    EtFuturumWorldGenerator.generateChorusPlant(world, xx, yy, zz, pass + 1);
                    grew = true;
                }
            }
            if (!grew) {
                world.func_147465_d(x, y + height, z, ModBlocks.chorus_flower, 5, 2);
            }
        }
    }
}

