/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.enchantment.FrostWalker;
import ganymedes01.etfuturum.enchantment.Mending;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public Configuration configFile;
    public String[] usedCategories = new String[]{"general"};

    private int configInteger(String name, boolean requireRestart, int def) {
        return this.configInteger(name, null, requireRestart, def);
    }

    private int configInteger(String name, String tooltip, boolean requireRestart, int def) {
        int config = this.configFile.get("general", name, def, tooltip).getInt(def);
        return config >= 0 ? config : def;
    }

    private boolean configBoolean(String name, String tooltip, boolean requireRestart, boolean def) {
        return this.configFile.get("general", name, def, tooltip).getBoolean(def);
    }

    private boolean configBoolean(String name, boolean requireRestart, boolean def) {
        return this.configBoolean(name, null, requireRestart, def);
    }

    public void init(File file) {
        this.configFile = new Configuration(file);
        this.syncConfigs();
    }

    private void syncConfigs() {
        EtFuturum.enableStones = this.configBoolean("Stones", true, EtFuturum.enableStones);
        EtFuturum.enableIronTrapdoor = this.configBoolean("Iron Trapdoor", true, EtFuturum.enableIronTrapdoor);
        EtFuturum.enableMutton = this.configBoolean("Mutton", true, EtFuturum.enableMutton);
        EtFuturum.enableSponge = this.configBoolean("Sponge", true, EtFuturum.enableSponge);
        EtFuturum.enablePrismarine = this.configBoolean("Prismarine", true, EtFuturum.enablePrismarine);
        EtFuturum.enableDoors = this.configBoolean("Doors", true, EtFuturum.enableDoors);
        EtFuturum.enableInvertedDaylightSensor = this.configBoolean("Inverted Daylight Sensor", true, EtFuturum.enableInvertedDaylightSensor);
        EtFuturum.enableCoarseDirt = this.configBoolean("Coarse Dirt", true, EtFuturum.enableCoarseDirt);
        EtFuturum.enableRedSandstone = this.configBoolean("Red Sandstone", true, EtFuturum.enableRedSandstone);
        EtFuturum.enableEnchants = this.configBoolean("Enchanting Table", true, EtFuturum.enableEnchants);
        EtFuturum.enableAnvil = this.configBoolean("Anvil", true, EtFuturum.enableAnvil);
        EtFuturum.enableFences = this.configBoolean("Fences and Gates", true, EtFuturum.enableFences);
        EtFuturum.enableSilkTouchingMushrooms = this.configBoolean("Mushroom Blocks", true, EtFuturum.enableSilkTouchingMushrooms);
        EtFuturum.enableBanners = this.configBoolean("Banners", true, EtFuturum.enableBanners);
        EtFuturum.enableSlimeBlock = this.configBoolean("Slime Block", true, EtFuturum.enableSlimeBlock);
        EtFuturum.enableArmourStand = this.configBoolean("Armour Stand", true, EtFuturum.enableArmourStand);
        EtFuturum.enableRabbit = this.configBoolean("Rabbits", true, EtFuturum.enableRabbit);
        EtFuturum.enableOldGravel = this.configBoolean("Old Gravel", true, EtFuturum.enableOldGravel);
        EtFuturum.enableRecipeForPrismarine = this.configBoolean("Recipes for prismarine", true, EtFuturum.enableRecipeForPrismarine);
        EtFuturum.enableEndermite = this.configBoolean("Endermite", true, EtFuturum.enableEndermite);
        EtFuturum.enableBeetroot = this.configBoolean("Beetroot", true, EtFuturum.enableBeetroot);
        EtFuturum.enableChorusFruit = this.configBoolean("Chorus Fruit (and related blocks)", true, EtFuturum.enableChorusFruit);
        EtFuturum.enableGrassPath = this.configBoolean("Grass Path", true, EtFuturum.enableGrassPath);
        EtFuturum.enableSticksFromDeadBushes = this.configBoolean("Dead Bushes drop sticks", true, EtFuturum.enableSticksFromDeadBushes);
        EtFuturum.enableBowRendering = this.configBoolean("Bows render pulling animation on inventory", true, EtFuturum.enableBowRendering);
        EtFuturum.enableTippedArrows = this.configBoolean("Tipped Arrows", true, EtFuturum.enableTippedArrows);
        EtFuturum.enableLingeringPotions = this.configBoolean("Lingering Potions", true, EtFuturum.enableLingeringPotions);
        EtFuturum.enableDmgIndicator = this.configBoolean("Heart Damage Indicator", true, EtFuturum.enableDmgIndicator);
        EtFuturum.enableTransparentAmour = this.configBoolean("Allow non-opaque armour", true, EtFuturum.enableTransparentAmour);
        EtFuturum.enableCryingObsidian = this.configBoolean("Crying Obsidian", true, EtFuturum.enableCryingObsidian);
        EtFuturum.enableUpdatedFoodValues = this.configBoolean("Use updated food values", true, EtFuturum.enableUpdatedFoodValues);
        EtFuturum.enableUpdatedHarvestLevels = this.configBoolean("Use updated harvest levels", true, EtFuturum.enableUpdatedHarvestLevels);
        EtFuturum.enableVillagerZombies = this.configBoolean("Villager Zombies", true, EtFuturum.enableVillagerZombies);
        EtFuturum.enableStoneBrickRecipes = this.configBoolean("Stone Brick Recipes", true, EtFuturum.enableStoneBrickRecipes);
        EtFuturum.enableBabyGrowthBoost = this.configBoolean("Baby growth boost", true, EtFuturum.enableBabyGrowthBoost);
        EtFuturum.enableVillagerTurnsIntoWitch = this.configBoolean("Villagers turn into Witches when struck by lightning", true, EtFuturum.enableVillagerTurnsIntoWitch);
        EtFuturum.enableElytra = this.configBoolean("Elytra", true, EtFuturum.enableElytra);
        EtFuturum.enableFancySkulls = this.configBoolean("Fancy Skulls", true, EtFuturum.enableFancySkulls);
        EtFuturum.enableSkullDrop = this.configBoolean("Skulls drop from charged creeper kills", true, EtFuturum.enableSkullDrop);
        EtFuturum.enableBurnableBlocks = this.configBoolean("Fences, gates and dead bushes burn", true, EtFuturum.enableBurnableBlocks);
        EtFuturum.enableFrostWalker = this.configBoolean("Frost Walker", true, EtFuturum.enableFrostWalker);
        EtFuturum.enableMending = this.configBoolean("Mending", true, EtFuturum.enableMending);
        EtFuturum.enableFrostWalker = this.configBoolean("Frost Walker", true, EtFuturum.enableFrostWalker);
        FrostWalker.ID = this.configInteger("Frost Walker ID", true, FrostWalker.ID);
        Mending.ID = this.configInteger("Mending ID", true, Mending.ID);
        EtFuturum.enableBrewingStands = this.configBoolean("Brewing Stands", true, EtFuturum.enableBrewingStands);
        EtFuturum.enableRoses = this.configBoolean("Old Roses", true, EtFuturum.enableRoses);
        EtFuturum.enableColourfulBeacons = this.configBoolean("Colourful Beacon Beams", true, EtFuturum.enableColourfulBeacons);
        EtFuturum.maxStonesPerCluster = this.configInteger("Max number of 1.8 stones in a cluster", true, EtFuturum.maxStonesPerCluster);
        EtFuturum.enablePlayerSkinOverlay = this.configBoolean("Skin overlays", true, EtFuturum.enablePlayerSkinOverlay);
        EtFuturum.enableShearableGolems = this.configBoolean("Shearing Snow Golems", true, EtFuturum.enableShearableGolems);
        EtFuturum.enableShearableCobwebs = this.configBoolean("Shears harvest cobwebs", true, EtFuturum.enableShearableCobwebs);
        EtFuturum.enableDragonRespawn = this.configBoolean("Dragon respawning", true, EtFuturum.enableDragonRespawn);
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("etfuturum".equals(eventArgs.modID)) {
            this.syncConfigs();
        }
    }
}

