/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.IConfigurable;
import ganymedes01.etfuturum.blocks.BlockGeneric;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.world.WorldCoord;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.Tuple;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Sponge
extends BlockGeneric
implements IConfigurable {
    public Sponge() {
        super(Material.field_151583_m, "", "wet");
        this.func_149711_c(0.6f);
        this.func_149672_a(field_149779_h);
        this.func_149658_d("sponge");
        this.func_149663_c(Utils.getUnlocalisedName("sponge"));
        this.func_149647_a((CreativeTabs)(EtFuturum.enableSponge ? EtFuturum.creativeTab : null));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.tryAbsorb(world, x, y, z, world.func_72805_g(x, y, z) == 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.tryAbsorb(world, x, y, z, world.func_72805_g(x, y, z) == 1);
        super.func_149695_a(world, x, y, z, neighborBlock);
    }

    protected void tryAbsorb(World worldIn, int x, int y, int z, boolean wet) {
        if (!wet && this.absorb(worldIn, x, y, z)) {
            worldIn.func_72921_c(x, y, z, 1, 2);
            worldIn.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)Blocks.field_150355_j));
        }
    }

    private boolean absorb(World world, int x, int y, int z) {
        LinkedList linkedlist = Lists.newLinkedList();
        ArrayList arraylist = Lists.newArrayList();
        linkedlist.add(new Tuple((Object)new WorldCoord(x, y, z), (Object)0));
        int i = 0;
        while (!linkedlist.isEmpty()) {
            Tuple tuple = (Tuple)linkedlist.poll();
            WorldCoord blockpos1 = (WorldCoord)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                WorldCoord blockpos2 = blockpos1.add(dir);
                if (world.func_147439_a(blockpos2.x, blockpos2.y, blockpos2.z).func_149688_o() != Material.field_151586_h) continue;
                world.func_147468_f(blockpos2.x, blockpos2.y, blockpos2.z);
                arraylist.add(blockpos2);
                ++i;
                if (j >= 6) continue;
                linkedlist.add(new Tuple((Object)blockpos2, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        for (WorldCoord blockpos1 : arraylist) {
            world.func_147460_e(blockpos1.x, blockpos1.y, blockpos1.z, Blocks.field_150350_a);
        }
        return i > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        ForgeDirection dir;
        if (world.func_72805_g(x, y, z) == 1 && (dir = this.getRandomDirection(rand)) != ForgeDirection.UP && !World.func_147466_a((IBlockAccess)world, (int)(x + dir.offsetX), (int)(y + dir.offsetY), (int)(z + dir.offsetZ))) {
            double d0 = x;
            double d1 = y;
            double d2 = z;
            if (dir == ForgeDirection.DOWN) {
                d1 -= 0.05;
                d0 += rand.nextDouble();
                d2 += rand.nextDouble();
            } else {
                d1 += rand.nextDouble() * 0.8;
                if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
                    d2 += rand.nextDouble();
                    d0 = dir == ForgeDirection.EAST ? (d0 += 1.0) : (d0 += 0.05);
                } else {
                    d0 += rand.nextDouble();
                    d2 = dir == ForgeDirection.SOUTH ? (d2 += 1.0) : (d2 += 0.05);
                }
            }
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    private ForgeDirection getRandomDirection(Random rand) {
        return ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
    }

    @Override
    public boolean isEnabled() {
        return EtFuturum.enableSponge;
    }
}

